/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.sweet;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;

public class SweetShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("sweetshrine");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);

    public SweetShrineBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.SWEET_SHRINE, PROPERTIES, pos, state);
    }

    private <T extends Entity> List<T> getEntities(Class<T> clazz) {
        return new ArrayList(this.getLevel().getEntitiesOfClass(clazz, this.getRange(), e -> !e.isSpectator()));
    }

    @Override
    protected boolean doPeriod() {
        int consumeAmount = this.getConsumeAmount();
        if (this.hasUpgrade(ShrineUpgrades.NECTAR)) {
            this.getEntities(Bee.class).forEach(e -> {
                if (this.elementStorage.getElementAmount() >= consumeAmount) {
                    this.consumeElement(consumeAmount);
                    e.setHasNectar(true);
                }
            });
        } else {
            this.getEntities(Player.class).forEach(e -> {
                FoodData foodData = e.getFoodData();
                if (this.elementStorage.getElementAmount() >= consumeAmount && foodData.getSaturationLevel() < 20.0f) {
                    this.consumeElement(consumeAmount);
                    foodData.eat((int)Math.round(this.getStrength()), (float)this.getStrength(1));
                }
            });
        }
        return false;
    }
}

