/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.spawning;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.entity.EntityHelper;

public class SpawningShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("spawningshrine");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);

    public SpawningShrineBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.SPAWNING_SHRINE, PROPERTIES, pos, state);
    }

    @Override
    protected boolean doPeriod() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AABB range = this.getRange();
            BlockPos pos = new BlockPos(serverLevel.random.nextInt((int)range.minX, (int)range.maxX), this.getTargetPos().getY(), serverLevel.random.nextInt((int)range.minZ, (int)range.maxZ));
            return EntityHelper.spawnMob(serverLevel, pos);
        }
        return false;
    }
}

