/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.overload;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.overload.OverloadShrineBlock;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;

public class OverloadShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("overloadshrine");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);
    private TickingBlockEntity ticker;

    public OverloadShrineBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.OVERLOAD_SHRINE, PROPERTIES, pos, state);
    }

    @Override
    public AABB lookupRange() {
        if (this.hasUpgrade(ShrineUpgrades.TRANSLOCATION)) {
            return super.lookupRange();
        }
        return this.lookupRange((Direction)this.getBlockState().getValue((Property)OverloadShrineBlock.FACING));
    }

    @Override
    public BlockPos getTargetPos() {
        return this.worldPosition.relative((Direction)this.getBlockState().getValue((Property)OverloadShrineBlock.FACING));
    }

    @Override
    protected boolean doPeriod() {
        TickingBlockEntity t = this.getTicker();
        if (t != null) {
            t.tick();
            return true;
        }
        return false;
    }

    private TickingBlockEntity getTicker() {
        if (this.ticker == null) {
            BlockPos target = this.getTargetPos();
            this.ticker = (TickingBlockEntity)this.level.getChunkAt((BlockPos)target).tickersInLevel.get(target);
        }
        if (this.ticker == null || this.ticker.isRemoved() || this.level.getBlockEntity(this.ticker.getPos()) instanceof AbstractShrineBlockEntity) {
            this.ticker = null;
        }
        return this.ticker;
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        return DEFAULT_UPGRADE_DIRECTIONS.stream().filter(direction -> direction != this.getBlockState().getValue((Property)OverloadShrineBlock.FACING)).collect(Collectors.toList());
    }
}

