/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.overload;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shape.ECShapes;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlock;
import sirttas.elementalcraft.block.shrine.overload.OverloadShrineBlockEntity;

public class OverloadShrineBlock
extends AbstractShrineBlock<OverloadShrineBlockEntity> {
    public static final String NAME = "overloadshrine";
    public static final MapCodec<OverloadShrineBlock> CODEC = OverloadShrineBlock.simpleCodec(OverloadShrineBlock::new);
    private static final VoxelShape BASE = Shapes.or((VoxelShape)ECShapes.SHRINE_SHAPE, (VoxelShape)Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0));
    private static final VoxelShape UP_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0));
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", d -> d != Direction.DOWN);

    public OverloadShrineBlock(BlockBehaviour.Properties properties) {
        super(ElementType.AIR, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<OverloadShrineBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.UP -> UP_SHAPE;
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> BASE;
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> container) {
        container.add(new Property[]{WATERLOGGED, FACING});
    }

    @Override
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        Direction direction = context.getClickedFace().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(direction.getAxis() == Direction.Axis.Y ? Direction.UP : direction));
    }
}

