/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.ore;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.Tags;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.block.shrine.upgrade.fortune.FortuneShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.fortune.greater.GreaterFortuneShrineUpgradeBlock;
import sirttas.elementalcraft.enchantment.ECEnchantmentHelper;
import sirttas.elementalcraft.loot.LootHelper;
import sirttas.elementalcraft.rune.Runes;
import sirttas.elementalcraft.tag.ECTags;

public class OreShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("oreshrine");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);
    public static final String CRYSTAL_HARVEST_RANGE_KEY = "crystal_harvest";
    private boolean hasCrystalHarvest = false;

    public OreShrineBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.ORE_SHRINE, PROPERTIES, pos, state);
    }

    private Optional<BlockPos> findOre() {
        return this.getBlocksInRange().filter(p -> this.level.getBlockState(p).is(this.hasCrystalHarvest ? ECTags.Blocks.SHRINES_ORE_HARVESTABLE_CRYSTALS : Tags.Blocks.ORES)).findAny();
    }

    @Override
    public AABB lookupRange() {
        if (this.hasUpgrade(ShrineUpgrades.CRYSTAL_HARVEST)) {
            return this.lookupRange(CRYSTAL_HARVEST_RANGE_KEY);
        }
        return super.lookupRange();
    }

    @Override
    protected boolean doPeriod() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.hasCrystalHarvest = this.hasUpgrade(ShrineUpgrades.CRYSTAL_HARVEST);
            return this.findOre().map(p -> {
                OreShrineBlockEntity.harvest(serverLevel, p, this, this.hasCrystalHarvest ? Blocks.AIR.defaultBlockState() : Blocks.STONE.defaultBlockState());
                return true;
            }).orElse(false);
        }
        return false;
    }

    public static void harvest(ServerLevel level, BlockPos pos, AbstractShrineBlockEntity shrine, @Nullable BlockState newState) {
        int fortune = OreShrineBlockEntity.getFortuneLevel(shrine);
        if (fortune > 0) {
            ItemStack pickaxe = new ItemStack((ItemLike)Items.NETHERITE_PICKAXE);
            pickaxe.enchant(ECEnchantmentHelper.getEnchantmentHolder(level.registryAccess(), (ResourceKey<Enchantment>)Enchantments.FORTUNE), fortune);
            LootHelper.getDrops(level, pos, pickaxe).forEach(s -> Block.popResource((Level)level, (BlockPos)shrine.getBlockPos().above(), (ItemStack)s));
        } else {
            LootHelper.getDrops(level, pos, shrine.hasUpgrade(ShrineUpgrades.SILK_TOUCH)).forEach(s -> Block.popResource((Level)level, (BlockPos)shrine.getBlockPos().above(), (ItemStack)s));
        }
        if (newState != null && !newState.isAir()) {
            level.setBlockAndUpdate(pos, newState);
        } else {
            level.destroyBlock(pos, false);
        }
    }

    private static int getFortuneLevel(AbstractShrineBlockEntity shrine) {
        int fortune = shrine.getUpgradeCount(ShrineUpgrades.FORTUNE) * ((FortuneShrineUpgradeBlock)((Object)ECBlocks.FORTUNE_SHRINE_UPGRADE.get())).getFortuneLevel();
        Direction direction = shrine.getUpgradeDirection(ShrineUpgrades.GREATER_FORTUNE);
        if (direction != null) {
            fortune += ((GreaterFortuneShrineUpgradeBlock)((Object)ECBlocks.GREATER_FORTUNE_SHRINE_UPGRADE.get())).getFortuneLevel();
            IRuneHandler runeHandler = (IRuneHandler)shrine.getLevel().getCapability(ElementalCraftCapabilities.RuneHandler.BLOCK, shrine.getBlockPos().relative(direction), null);
            if (runeHandler != null && runeHandler.getRuneCount(Runes.TZEENTCH) > 0) {
                ++fortune;
            }
        }
        return fortune;
    }
}

