/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.melting;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.melting.MeltingRecipe;
import sirttas.elementalcraft.recipe.melting.MeltingRecipeInput;

public class MeltingShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("melting_shrine");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);
    protected static final List<Direction> UPGRADE_DIRECTIONS = List.of(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);
    private int cooldown = 0;

    public MeltingShrineBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.LAVA_SHRINE, PROPERTIES, pos, state);
    }

    public static boolean fill(AbstractShrineBlockEntity shrine, Direction fillingDirection, Fluid fluid, float fluidMultiplier) {
        IFluidHandler fluidHandler = (IFluidHandler)shrine.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, shrine.getBlockPos().relative(fillingDirection, 2), (Object)fillingDirection.getOpposite());
        return fluidHandler != null && fluidHandler.fill(new FluidStack(fluid, (int)Math.round(shrine.getStrength() * (double)fluidMultiplier)), IFluidHandler.FluidAction.EXECUTE) > 0;
    }

    private Optional<MeltingRecipe> findRecipe() {
        MeltingRecipeInput input = new MeltingRecipeInput(this.level.getBlockState(this.getTargetPos()), this.getElementStorage().getElementAmount(), this.getConsumeAmount());
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ECRecipeTypes.MELTING.get(), (RecipeInput)input, this.level).map(RecipeHolder::value);
    }

    @Override
    public BlockPos getTargetPos() {
        return this.worldPosition.above();
    }

    @Override
    protected boolean doPeriod() {
        if (this.cooldown > 0) {
            --this.cooldown;
        } else {
            this.findRecipe().ifPresent(this::melt);
        }
        return false;
    }

    private void melt(MeltingRecipe recipe) {
        Direction fillingDirection = this.getUpgradeDirection(ShrineUpgrades.FILLING);
        if (fillingDirection != null && MeltingShrineBlockEntity.fill(this, fillingDirection, recipe.result(), recipe.fillingAmount())) {
            this.level.destroyBlock(this.getTargetPos(), false);
        } else {
            this.level.setBlock(this.getTargetPos(), recipe.result().defaultFluidState().createLegacyBlock(), 11);
            this.level.levelEvent(1501, this.getTargetPos(), 0);
        }
        this.cooldown = recipe.cooldown() - 1;
        this.consumeElement(recipe.elementAmount() * this.getConsumeAmount());
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        return UPGRADE_DIRECTIONS;
    }
}

