/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.melting;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shape.ECShapes;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlock;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.melting.MeltingShrineBlockEntity;

public class MeltingShrineBlock
extends AbstractShrineBlock<MeltingShrineBlockEntity> {
    public static final String NAME = "melting_shrine";
    public static final MapCodec<MeltingShrineBlock> CODEC = MeltingShrineBlock.simpleCodec(MeltingShrineBlock::new);
    private static final VoxelShape BASE_1 = Block.box((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    private static final VoxelShape BASE_2 = Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)ECShapes.SHRINE_SHAPE, (VoxelShape[])new VoxelShape[]{BASE_1, BASE_2});

    public MeltingShrineBlock(BlockBehaviour.Properties properties) {
        super(ElementType.FIRE, properties);
    }

    @NotNull
    protected MapCodec<MeltingShrineBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Override
    protected void doAnimateTick(AbstractShrineBlockEntity shrine, BlockState state, Level level, BlockPos pos, RandomSource rand) {
        double x = (double)pos.getX() + (4.0 + rand.nextDouble() * 7.0) / 16.0;
        double y = (double)pos.getY() + 0.375;
        double z = (double)pos.getZ() + (4.0 + rand.nextDouble() * 7.0) / 16.0;
        level.addParticle((ParticleOptions)ParticleTypes.LAVA, x, y, z, 0.0, 0.0, 0.0);
    }
}

