/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.lumber;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.block.shrine.upgrade.vertical.PlantingShrineUpgradeBlock;
import sirttas.elementalcraft.loot.LootHelper;
import sirttas.elementalcraft.tag.ECTags;

public class LumberShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("lumbershrine");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);

    public LumberShrineBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.LUMBER_SHRINE, PROPERTIES, pos, state);
    }

    private Optional<BlockPos> findTreeBlock() {
        if (this.level == null) {
            return Optional.empty();
        }
        return this.getBlocksInRange().filter(p -> this.level.getBlockState(p).is(ECTags.Blocks.TREE_PARTS)).findAny();
    }

    private void handlePlanting(BlockPos pos, List<ItemStack> loots) {
        if (this.hasUpgrade(ShrineUpgrades.PLANTING)) {
            int y = this.worldPosition.getY();
            loots.stream().filter(stack -> stack.is(ItemTags.SAPLINGS)).findFirst().ifPresent(seeds -> {
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos.getX(), pos.getY(), pos.getZ());
                boolean hasPlanted = false;
                do {
                    hasPlanted = PlantingShrineUpgradeBlock.plant(seeds, this.level, (BlockPos)mutablePos);
                    mutablePos.move(Direction.DOWN);
                } while (!hasPlanted && mutablePos.getY() >= y);
                if (hasPlanted) {
                    seeds.shrink(1);
                    if (seeds.isEmpty()) {
                        loots.remove(seeds);
                    }
                }
            });
        }
    }

    @Override
    protected boolean doPeriod() {
        if (this.level instanceof ServerLevel && !this.level.isClientSide) {
            return this.findTreeBlock().map(p -> {
                List<ItemStack> loots = LootHelper.getDrops((ServerLevel)this.level, p, this.hasUpgrade(ShrineUpgrades.SILK_TOUCH) ? new ItemStack((ItemLike)Items.SHEARS) : ItemStack.EMPTY);
                this.level.destroyBlock(p, false);
                this.handlePlanting((BlockPos)p, loots);
                loots.forEach(stack -> Block.popResource((Level)this.level, (BlockPos)p, (ItemStack)stack));
                return true;
            }).orElse(false);
        }
        return false;
    }
}

