/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.harvest;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.block.shrine.upgrade.vertical.PlantingShrineUpgradeBlock;
import sirttas.elementalcraft.loot.LootHelper;
import sirttas.elementalcraft.tag.ECTags;

public class HarvestShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("harvestshrine");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);
    protected static final List<Direction> UPGRADE_DIRECTIONS = List.of(Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);

    public HarvestShrineBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.HARVEST_SHRINE, PROPERTIES, pos, state);
    }

    private Optional<BlockPos> findCrop() {
        return this.getBlocksInRange().filter(this::canHarvest).findAny();
    }

    private boolean canHarvest(BlockPos pos) {
        CropBlock cropBlock;
        BlockState state = this.level.getBlockState(pos);
        Block block = state.getBlock();
        return block instanceof CropBlock && (cropBlock = (CropBlock)block).isMaxAge(state) || state.is(ECTags.Blocks.SHRINES_HARVEST_HARVESTABLE_TALL_PLANTS) && this.level.getBlockState(pos.below()).is(ECTags.Blocks.SHRINES_HARVEST_HARVESTABLE_TALL_PLANTS);
    }

    private void handlePlanting(BlockPos pos, ItemLike provider, List<ItemStack> loots) {
        Item item;
        if (!this.hasUpgrade(ShrineUpgrades.PLANTING) || !((item = provider.asItem()) instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        loots.stream().filter(stack -> stack.getItem().equals(blockItem)).findFirst().ifPresent(seeds -> {
            if (PlantingShrineUpgradeBlock.plant(seeds, this.level, pos)) {
                seeds.shrink(1);
                if (seeds.isEmpty()) {
                    loots.remove(seeds);
                }
            }
        });
    }

    @Override
    protected boolean doPeriod() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.level.isClientSide) {
                return this.findCrop().map(p -> {
                    List<ItemStack> loots = LootHelper.getDrops(serverLevel, p);
                    Block block = this.level.getBlockState(p).getBlock();
                    this.level.destroyBlock(p, false);
                    this.handlePlanting((BlockPos)p, (ItemLike)block, loots);
                    loots.forEach(stack -> Block.popResource((Level)this.level, (BlockPos)p, (ItemStack)stack));
                    return true;
                }).orElse(false);
            }
        }
        return false;
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        return UPGRADE_DIRECTIONS;
    }
}

