/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.growth;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.tag.ECTags;

public class GrowthShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("growthshrine");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);
    public static final String CRYSTAL_GROWTH_RANGE_KEY = "crystal_growth";
    private static final int MAX_TRYS = 100;
    private boolean hasStemPollination = false;

    public GrowthShrineBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.GROWTH_SHRINE, PROPERTIES, pos, state);
    }

    private Optional<BlockPos> findGrowable() {
        List<BlockPos> positions = this.getBlocksInRange().filter(this::canGrow).toList();
        return positions.isEmpty() ? Optional.empty() : Optional.of(positions.get(this.level.random.nextInt(positions.size())));
    }

    private boolean stemCanGrow(StemBlock stem, BlockPos pos) {
        if (this.hasStemPollination) {
            ResourceKey fruit = stem.fruit;
            return Direction.Plane.HORIZONTAL.stream().map(d -> this.level.getBlockState(pos.relative(d))).noneMatch(state -> state.is(fruit));
        }
        return false;
    }

    private boolean canGrow(BlockPos pos) {
        BlockState state = this.level.getBlockState(pos);
        if (this.isInBlacklist(state)) {
            return false;
        }
        Block block = state.getBlock();
        if (block instanceof BonemealableBlock) {
            StemBlock stem;
            BonemealableBlock growable = (BonemealableBlock)block;
            return growable.isValidBonemealTarget((LevelReader)this.level, pos, state) && growable.isBonemealSuccess(this.level, this.level.random, pos, state) || block instanceof StemBlock && this.stemCanGrow(stem = (StemBlock)block, pos);
        }
        return false;
    }

    private boolean isInBlacklist(BlockState state) {
        return state.is(ECTags.Blocks.SHRINES_GROWTH_BLACKLIST);
    }

    private void addGrowthParticles(BlockPos pos) {
        this.level.levelEvent(1505, pos, 0);
    }

    @Override
    public AABB lookupRange() {
        if (this.hasUpgrade(ShrineUpgrades.CRYSTAL_GROWTH)) {
            return this.lookupRange(CRYSTAL_GROWTH_RANGE_KEY);
        }
        return super.lookupRange();
    }

    private boolean growBoneless() {
        int consumeAmount = this.getConsumeAmount();
        List<BlockPos> positions = this.getBlocksInRange().toList();
        for (BlockPos pos : positions) {
            Block block;
            BlockState state = this.level.getBlockState(pos);
            if (this.isInBlacklist(state) || !((block = state.getBlock()) instanceof BonemealableBlock) && !state.is(ECTags.Blocks.SHRINES_GROWTH_BONELESS) || block instanceof StemBlock || !state.isRandomlyTicking() || this.elementStorage.getElementAmount() < consumeAmount) continue;
            state.randomTick((ServerLevel)this.level, pos, this.level.random);
            BlockState newState = this.level.getBlockState(pos);
            if (newState == state) continue;
            this.consumeElement(consumeAmount);
            this.addGrowthParticles(pos);
        }
        return false;
    }

    private boolean growStandard() {
        return this.findGrowable().map(p -> {
            BlockState blockstate = this.level.getBlockState(p);
            ((BonemealableBlock)blockstate.getBlock()).performBonemeal((ServerLevel)this.level, this.level.random, p, blockstate);
            this.addGrowthParticles((BlockPos)p);
            return true;
        }).orElse(false);
    }

    private boolean canClusterGrowAtState(BlockState s) {
        return BuddingAmethystBlock.canClusterGrowAtState((BlockState)s) || s.is(ECTags.Blocks.BUDS);
    }

    private boolean canGrowCrystal(BlockPos pos) {
        BlockState state = this.level.getBlockState(pos);
        if (state.is(ECTags.Blocks.BUDDING) && state.isRandomlyTicking()) {
            for (Direction direction : Direction.values()) {
                BlockPos offset = pos.relative(direction);
                BlockState s = this.level.getBlockState(offset);
                if (!this.canClusterGrowAtState(s)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean growCrystals() {
        List<BlockPos> positions = this.getBlocksInRange().filter(this::canGrowCrystal).toList();
        if (positions.isEmpty()) {
            return false;
        }
        BlockPos pos = positions.get(this.level.random.nextInt(positions.size()));
        BlockState state = this.level.getBlockState(pos);
        EnumMap<Direction, BlockState> map = new EnumMap<Direction, BlockState>(Direction.class);
        for (Direction direction : Direction.values()) {
            BlockPos offset = pos.relative(direction);
            BlockState s = this.level.getBlockState(offset);
            if (!this.canClusterGrowAtState(s)) continue;
            map.put(direction, s);
        }
        for (int tryCount = 0; tryCount < 100; ++tryCount) {
            state.randomTick((ServerLevel)this.level, pos, this.level.random);
            for (Map.Entry e : map.entrySet()) {
                BlockPos offset = pos.relative((Direction)e.getKey());
                if (this.level.getBlockState(offset) == e.getValue()) continue;
                this.addGrowthParticles(offset);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean doPeriod() {
        if (this.level instanceof ServerLevel) {
            this.hasStemPollination = this.hasUpgrade(ShrineUpgrades.STEM_POLLINATION);
            if (this.hasUpgrade(ShrineUpgrades.CRYSTAL_GROWTH)) {
                return this.growCrystals();
            }
            if (this.hasUpgrade(ShrineUpgrades.BONELESS_GROWTH)) {
                return this.growBoneless();
            }
            return this.growStandard();
        }
        return false;
    }
}

