/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.grove;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.ElementalCraftUtils;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.tag.ECTags;

public class GroveShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("groveshrine");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);
    private static final Lazy<HolderSet.Named<Item>> MYSTICAL_GROVE_FLOWERS = Lazy.of(() -> ECTags.Items.getTag(ECTags.Items.MYSTICAL_GROVE_FLOWERS));
    private static final Lazy<HolderSet.Named<Item>> GROVE_SHRINE_FLOWERS = Lazy.of(() -> ECTags.Items.getTag(ECTags.Items.GROVE_SHRINE_FLOWERS));

    public GroveShrineBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.GROVE_SHRINE, PROPERTIES, pos, state);
    }

    private Optional<BlockPos> findGrass() {
        List<BlockPos> positions = this.getBlocksInRange().filter(this::canPlant).map(BlockPos::above).toList();
        return positions.isEmpty() ? Optional.empty() : Optional.of(positions.get(this.level.random.nextInt(positions.size())));
    }

    private boolean canPlant(BlockPos pos) {
        BlockPos up = pos.above();
        return this.level.getBlockState(pos).getBlock() == Blocks.GRASS_BLOCK && this.level.getBlockState(up).isAir();
    }

    @Override
    protected boolean doPeriod() {
        if (this.level instanceof ServerLevel) {
            return this.findGrass().map(p -> {
                BlockItem item = this.findFlower();
                if (!item.place((BlockPlaceContext)new DirectionalPlaceContext(this.level, p, Direction.DOWN, new ItemStack((ItemLike)item), Direction.UP)).consumesAction()) {
                    ElementalCraftApi.LOGGER.warn("Failed to place flower: {} at {}", (Object)item, p);
                    return false;
                }
                this.level.levelEvent(1505, p, 0);
                return true;
            }).orElse(false);
        }
        return false;
    }

    private BlockItem findFlower() {
        List<BlockItem> flowers = (this.hasUpgrade(ShrineUpgrades.MYSTICAL_GROVE) ? ((HolderSet.Named)MYSTICAL_GROVE_FLOWERS.get()).stream() : ((HolderSet.Named)GROVE_SHRINE_FLOWERS.get()).stream().filter(item -> !item.is(ECTags.Items.GROVE_SHRINE_BLACKLIST))).map(Holder::value).mapMulti(ElementalCraftUtils.cast(BlockItem.class)).toList();
        return flowers.get(this.level.random.nextInt(flowers.size()));
    }
}

