/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.firepylon;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;

public class FirePylonBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("firepylon");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);
    protected static final List<Direction> UPGRADE_DIRECTIONS = List.of(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);

    public FirePylonBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.FIRE_PYLON, PROPERTIES, pos, state);
    }

    private List<LivingEntity> getEntities() {
        return this.getLevel().getEntitiesOfClass(LivingEntity.class, this.getRange(), e -> !e.isSpectator() && !e.hasEffect(MobEffects.FIRE_RESISTANCE) && !e.isOnFire() && !ToolInfusionHelper.hasFireInfusion((Entity)e) && (!this.hasUpgrade(ShrineUpgrades.PROTECTION) || EntityHelper.isHostile((Entity)e)));
    }

    @Override
    protected boolean doPeriod() {
        int consumeAmount = this.getConsumeAmount();
        this.getEntities().forEach(e -> {
            if (this.elementStorage.getElementAmount() >= consumeAmount) {
                e.hurt(this.level.damageSources().inFire(), (float)this.getStrength());
                e.igniteForSeconds((float)Math.max(1, (int)((double)this.consumeElement(consumeAmount) * this.getStrength(1))));
            }
        });
        return false;
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        return UPGRADE_DIRECTIONS;
    }
}

