/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.firepylon;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shape.ECShapes;
import sirttas.elementalcraft.block.shrine.AbstractPylonShrineBlock;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.firepylon.FirePylonBlockEntity;

public class FirePylonBlock
extends AbstractPylonShrineBlock<FirePylonBlockEntity> {
    public static final String NAME = "firepylon";
    public static final MapCodec<FirePylonBlock> CODEC = FirePylonBlock.simpleCodec(FirePylonBlock::new);
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    private static final VoxelShape BASE = Block.box((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape IRON_NORTH = Block.box((double)7.0, (double)12.0, (double)5.0, (double)9.0, (double)14.0, (double)6.0);
    private static final VoxelShape IRON_SOUTH = Block.box((double)7.0, (double)12.0, (double)10.0, (double)9.0, (double)14.0, (double)11.0);
    private static final VoxelShape IRON_EAST = Block.box((double)10.0, (double)12.0, (double)7.0, (double)11.0, (double)14.0, (double)9.0);
    private static final VoxelShape IRON_WEST = Block.box((double)5.0, (double)12.0, (double)7.0, (double)6.0, (double)14.0, (double)9.0);
    private static final VoxelShape UPPER_BASE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)7.0, (double)10.0);
    private static final VoxelShape UPPER_TOP = Block.box((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape LOWER_SHAPE = Shapes.or((VoxelShape)ECShapes.SHRINE_SHAPE, (VoxelShape[])new VoxelShape[]{BASE, IRON_NORTH, IRON_SOUTH, IRON_EAST, IRON_WEST});
    private static final VoxelShape UPPER_SHAPE = Shapes.or((VoxelShape)UPPER_BASE, (VoxelShape)UPPER_TOP);

    public FirePylonBlock(BlockBehaviour.Properties properties) {
        super(ElementType.FIRE, properties);
    }

    @NotNull
    protected MapCodec<FirePylonBlock> codec() {
        return CODEC;
    }

    @Override
    public FirePylonBlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? (FirePylonBlockEntity)super.newBlockEntity(pos, state) : null;
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? LOWER_SHAPE : UPPER_SHAPE;
    }

    @Override
    protected void doAnimateTick(AbstractShrineBlockEntity shrine, BlockState state, Level level, BlockPos pos, RandomSource rand) {
        double x = (double)pos.getX() + (4.0 + rand.nextDouble() * 7.0) / 16.0;
        double y = (double)pos.getY() + 0.375;
        double z = (double)pos.getZ() + (4.0 + rand.nextDouble() * 7.0) / 16.0;
        level.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y + 0.5, z, 0.0, 0.0, 0.0);
    }
}

