/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.enderlock;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shape.ECShapes;
import sirttas.elementalcraft.block.shrine.AbstractPylonShrineBlock;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.enderlock.EnderLockShrineBlockEntity;
import sirttas.elementalcraft.particle.ParticleHelper;

public class EnderLockShrineBlock
extends AbstractPylonShrineBlock<EnderLockShrineBlockEntity> {
    public static final String NAME = "enderlockshrine";
    public static final MapCodec<EnderLockShrineBlock> CODEC = EnderLockShrineBlock.simpleCodec(EnderLockShrineBlock::new);
    private static final VoxelShape BASE = Block.box((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape IRON_NORTH = Block.box((double)7.0, (double)12.0, (double)5.0, (double)9.0, (double)14.0, (double)6.0);
    private static final VoxelShape IRON_SOUTH = Block.box((double)7.0, (double)12.0, (double)10.0, (double)9.0, (double)14.0, (double)11.0);
    private static final VoxelShape IRON_EAST = Block.box((double)10.0, (double)12.0, (double)7.0, (double)11.0, (double)14.0, (double)9.0);
    private static final VoxelShape IRON_WEST = Block.box((double)5.0, (double)12.0, (double)7.0, (double)6.0, (double)14.0, (double)9.0);
    private static final VoxelShape UPPER_BASE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0);
    private static final VoxelShape UPPER_RING_1 = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0);
    private static final VoxelShape UPPER_RING_2 = Block.box((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    private static final VoxelShape UPPER_RING_3 = Block.box((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0);
    private static final VoxelShape LOWER_SHAPE = Shapes.or((VoxelShape)ECShapes.SHRINE_SHAPE, (VoxelShape[])new VoxelShape[]{BASE, IRON_NORTH, IRON_SOUTH, IRON_EAST, IRON_WEST});
    private static final VoxelShape UPPER_SHAPE = Shapes.or((VoxelShape)UPPER_BASE, (VoxelShape[])new VoxelShape[]{UPPER_RING_1, UPPER_RING_2, UPPER_RING_3});

    public EnderLockShrineBlock(BlockBehaviour.Properties properties) {
        super(ElementType.WATER, properties);
    }

    @NotNull
    protected MapCodec<EnderLockShrineBlock> codec() {
        return CODEC;
    }

    @Override
    public EnderLockShrineBlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER ? (EnderLockShrineBlockEntity)super.newBlockEntity(pos, state) : null;
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER ? LOWER_SHAPE : UPPER_SHAPE;
    }

    @Override
    protected void doAnimateTick(AbstractShrineBlockEntity shrine, BlockState state, Level level, BlockPos pos, RandomSource rand) {
        ParticleHelper.createEnderParticle(level, Vec3.atLowerCornerOf((Vec3i)pos), 8 + rand.nextInt(5), rand);
    }
}

