/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.enderlock;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import sirttas.elementalcraft.block.shrine.enderlock.EnderLockShrineBlockEntity;

@EventBusSubscriber(modid="elementalcraft")
public class EnderLockHandler {
    private static final Multimap<Level, EnderLockShrineBlockEntity> ENDER_LOCK_SHRINES = HashMultimap.create();
    private static final Set<Class<? extends EntityTeleportEvent>> PROTECTED_EVENTS = new HashSet<Class<? extends EntityTeleportEvent>>();

    private EnderLockHandler() {
    }

    @SubscribeEvent
    public static void onEntityTeleport(EntityTeleportEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (PROTECTED_EVENTS.contains(event.getClass()) || entity instanceof Player && ((player = (Player)entity).isSpectator() || player.isCreative())) {
            return;
        }
        Collection shrines = ENDER_LOCK_SHRINES.get((Object)entity.level());
        shrines.removeIf(BlockEntity::isRemoved);
        event.setCanceled(shrines.stream().anyMatch(shrine -> shrine.doLock(entity)));
    }

    public static void add(EnderLockShrineBlockEntity shrine) {
        if (!shrine.isRemoved() && shrine.hasLevel()) {
            ENDER_LOCK_SHRINES.put((Object)shrine.getLevel(), (Object)shrine);
        }
    }

    public static void protect(Class<? extends EntityTeleportEvent> event) {
        PROTECTED_EVENTS.add(event);
    }

    static {
        EnderLockHandler.protect(EntityTeleportEvent.TeleportCommand.class);
        EnderLockHandler.protect(EntityTeleportEvent.SpreadPlayersCommand.class);
    }
}

