/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.budding;

import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.util.Lazy;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.budding.BuddingShrineBlock;
import sirttas.elementalcraft.block.shrine.ore.OreShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;

public class BuddingShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("buddingshrine");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);
    protected static final List<Direction> UPGRADE_DIRECTIONS = List.of(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);
    private static final Lazy<List<Block>> AMETHYSTS = Lazy.of(() -> List.of(Blocks.SMALL_AMETHYST_BUD, Blocks.MEDIUM_AMETHYST_BUD, Blocks.LARGE_AMETHYST_BUD, Blocks.AMETHYST_CLUSTER));
    private static final Lazy<List<Block>> SPRINGALINES = Lazy.of(() -> List.of((Block)ECBlocks.SMALL_SPRINGALINE_BUD.get(), (Block)ECBlocks.MEDIUM_SPRINGALINE_BUD.get(), (Block)ECBlocks.LARGE_SPRINGALINE_BUD.get(), (Block)ECBlocks.SPRINGALINE_CLUSTER.get()));

    public BuddingShrineBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.BUDDING_SHRINE, PROPERTIES, pos, state);
    }

    private BlockPos above() {
        return this.getTargetPos().above();
    }

    @Override
    protected boolean doPeriod() {
        return switch ((BuddingShrineBlock.CrystalType)((Object)this.getBlockState().getValue(BuddingShrineBlock.CRYSTAL_TYPE))) {
            case BuddingShrineBlock.CrystalType.SPRINGALINE -> this.grow((List)SPRINGALINES.get());
            default -> this.grow((List)AMETHYSTS.get());
        };
    }

    private boolean grow(List<Block> blocks) {
        BlockState state = this.level.getBlockState(this.above());
        if (BuddingAmethystBlock.canClusterGrowAtState((BlockState)state)) {
            this.setBud(blocks.get(0), state);
            return true;
        }
        Iterator<Block> it = blocks.iterator();
        while (it.hasNext()) {
            if (!state.is(it.next())) continue;
            if (it.hasNext()) {
                this.setBud(it.next(), state);
                return true;
            }
            Level level = this.level;
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.hasUpgrade(ShrineUpgrades.CRYSTAL_HARVEST)) continue;
            BlockPos above = this.worldPosition.above();
            OreShrineBlockEntity.harvest(serverLevel, above, this, Blocks.AIR.defaultBlockState());
            return true;
        }
        return false;
    }

    private void setBud(Block block, BlockState state) {
        this.level.setBlockAndUpdate(this.above(), (BlockState)((BlockState)block.defaultBlockState().setValue((Property)AmethystClusterBlock.FACING, (Comparable)Direction.UP)).setValue((Property)AmethystClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(state.getFluidState().getType() == Fluids.WATER)));
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        return UPGRADE_DIRECTIONS;
    }
}

