/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.budding;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shape.ECShapes;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlock;
import sirttas.elementalcraft.block.shrine.budding.BuddingShrineBlockEntity;

public class BuddingShrineBlock
extends AbstractShrineBlock<BuddingShrineBlockEntity> {
    public static final String NAME = "buddingshrine";
    public static final MapCodec<BuddingShrineBlock> CODEC = BuddingShrineBlock.simpleCodec(BuddingShrineBlock::new);
    public static final EnumProperty<CrystalType> CRYSTAL_TYPE = EnumProperty.create((String)"crystal_type", CrystalType.class);
    private static final VoxelShape BASE_1 = Block.box((double)2.0, (double)10.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    private static final VoxelShape BASE_2 = Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape PLATE = Block.box((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)ECShapes.SHRINE_SHAPE, (VoxelShape[])new VoxelShape[]{BASE_1, BASE_2, PLATE});

    public BuddingShrineBlock(BlockBehaviour.Properties properties) {
        super(ElementType.EARTH, properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(CRYSTAL_TYPE, (Comparable)((Object)CrystalType.AMETHYST))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<BuddingShrineBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, CRYSTAL_TYPE});
    }

    public static enum CrystalType implements StringRepresentable
    {
        AMETHYST("amethyst"),
        SPRINGALINE("springaline");

        private final String name;

        private CrystalType(String name) {
            this.name = name;
        }

        @Nonnull
        public String getSerializedName() {
            return this.name;
        }
    }
}

