/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.breeding;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.breeding.BreedingShrineBlock;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;

public class BreedingShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("breedingshrine");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);

    public BreedingShrineBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.BREEDING_SHRINE, PROPERTIES, pos, state);
    }

    private <T extends Entity> List<T> getEntities(Class<T> clazz) {
        return this.getLevel().getEntitiesOfClass(clazz, this.getRange(), e -> !e.isSpectator());
    }

    @Override
    public AABB lookupRange() {
        if (this.hasUpgrade(ShrineUpgrades.TRANSLOCATION)) {
            return super.lookupRange();
        }
        return this.lookupRange((Direction)this.getBlockState().getValue((Property)BreedingShrineBlock.FACING));
    }

    @Override
    protected boolean doPeriod() {
        EntityType type = null;
        Animal first = null;
        Animal second = null;
        for (Animal entity : this.getEntities(Animal.class)) {
            if (type == null && entity.canFallInLove()) {
                type = entity.getType();
                first = entity;
                continue;
            }
            if (second != null || type == null || !type.equals(entity.getType()) || !entity.canFallInLove()) continue;
            second = entity;
        }
        if (first != null && second != null) {
            return this.feed(first, second);
        }
        return false;
    }

    public boolean consumeFood(Animal first) {
        List<ItemStack> foodList = this.getEntities(ItemEntity.class).stream().map(ItemEntity::getItem).filter(stack -> first.isFood(stack) && !stack.isEmpty()).toList();
        if (foodList.isEmpty()) {
            return false;
        }
        if (foodList.get(0).getCount() >= 2) {
            foodList.get(0).shrink(2);
        } else if (foodList.size() >= 2) {
            foodList.get(0).shrink(1);
            foodList.get(1).shrink(1);
        } else {
            return false;
        }
        return true;
    }

    public boolean feed(Animal first, Animal second) {
        if (!this.consumeFood(first)) {
            return false;
        }
        this.setInLove(first);
        this.setInLove(second);
        return true;
    }

    private void setInLove(Animal first) {
        first.setInLoveTime(600);
        this.level.broadcastEntityEvent((Entity)first, (byte)18);
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        BlockState state = this.getBlockState();
        return state.getValue(BreedingShrineBlock.PART) == BreedingShrineBlock.Part.BOWL ? Collections.emptyList() : DEFAULT_UPGRADE_DIRECTIONS.stream().filter(direction -> direction != state.getValue((Property)BreedingShrineBlock.FACING)).collect(Collectors.toList());
    }
}

