/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.breeding;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shape.ECShapes;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlock;
import sirttas.elementalcraft.block.shrine.breeding.BreedingShrineBlockEntity;

public class BreedingShrineBlock
extends AbstractShrineBlock<BreedingShrineBlockEntity> {
    public static final String NAME = "breedingshrine";
    public static final MapCodec<BreedingShrineBlock> CODEC = BreedingShrineBlock.simpleCodec(BreedingShrineBlock::new);
    private static final VoxelShape BASE_CORE = Shapes.or((VoxelShape)ECShapes.SHRINE_SHAPE, (VoxelShape)Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0));
    private static final VoxelShape CORE_NORTH_1 = Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)12.0, (double)3.0);
    private static final VoxelShape CORE_NORTH_2 = Block.box((double)5.0, (double)12.0, (double)0.0, (double)11.0, (double)14.0, (double)5.0);
    private static final VoxelShape CORE_SOUTH_1 = Block.box((double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)12.0, (double)16.0);
    private static final VoxelShape CORE_SOUTH_2 = Block.box((double)5.0, (double)12.0, (double)11.0, (double)11.0, (double)14.0, (double)16.0);
    private static final VoxelShape CORE_WEST_1 = Block.box((double)0.0, (double)3.0, (double)3.0, (double)3.0, (double)12.0, (double)13.0);
    private static final VoxelShape CORE_WEST_2 = Block.box((double)0.0, (double)12.0, (double)5.0, (double)5.0, (double)14.0, (double)11.0);
    private static final VoxelShape CORE_EAST_1 = Block.box((double)13.0, (double)3.0, (double)3.0, (double)16.0, (double)12.0, (double)13.0);
    private static final VoxelShape CORE_EAST_2 = Block.box((double)11.0, (double)12.0, (double)5.0, (double)16.0, (double)14.0, (double)11.0);
    private static final VoxelShape CORE_NORTH = Shapes.or((VoxelShape)BASE_CORE, (VoxelShape[])new VoxelShape[]{CORE_NORTH_1, CORE_NORTH_2});
    private static final VoxelShape CORE_SOUTH = Shapes.or((VoxelShape)BASE_CORE, (VoxelShape[])new VoxelShape[]{CORE_SOUTH_1, CORE_SOUTH_2});
    private static final VoxelShape CORE_WEST = Shapes.or((VoxelShape)BASE_CORE, (VoxelShape[])new VoxelShape[]{CORE_WEST_1, CORE_WEST_2});
    private static final VoxelShape CORE_EAST = Shapes.or((VoxelShape)BASE_CORE, (VoxelShape[])new VoxelShape[]{CORE_EAST_1, CORE_EAST_2});
    private static final VoxelShape BASE_BOWL_FULL = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0);
    private static final VoxelShape BASE_BOWL_VOID = Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0);
    private static final VoxelShape BASE_BOWL = Shapes.join((VoxelShape)BASE_BOWL_FULL, (VoxelShape)BASE_BOWL_VOID, (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape BOWL_NORTH_1 = Block.box((double)5.0, (double)7.0, (double)11.0, (double)11.0, (double)12.0, (double)13.0);
    private static final VoxelShape BOWL_NORTH_2 = Block.box((double)5.0, (double)12.0, (double)11.0, (double)11.0, (double)14.0, (double)16.0);
    private static final VoxelShape BOWL_NORTH_3 = Block.box((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)12.0, (double)16.0);
    private static final VoxelShape BOWL_NORTH_TAPE = Block.box((double)7.0, (double)10.0, (double)8.0, (double)9.0, (double)12.0, (double)11.0);
    private static final VoxelShape BOWL_SOUTH_1 = Block.box((double)5.0, (double)7.0, (double)3.0, (double)11.0, (double)12.0, (double)5.0);
    private static final VoxelShape BOWL_SOUTH_2 = Block.box((double)5.0, (double)12.0, (double)0.0, (double)11.0, (double)14.0, (double)5.0);
    private static final VoxelShape BOWL_SOUTH_3 = Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)12.0, (double)3.0);
    private static final VoxelShape BOWL_SOUTH_TAPE = Block.box((double)7.0, (double)10.0, (double)5.0, (double)9.0, (double)12.0, (double)8.0);
    private static final VoxelShape BOWL_WEST_1 = Block.box((double)11.0, (double)7.0, (double)5.0, (double)13.0, (double)12.0, (double)11.0);
    private static final VoxelShape BOWL_WEST_2 = Block.box((double)11.0, (double)12.0, (double)5.0, (double)16.0, (double)14.0, (double)11.0);
    private static final VoxelShape BOWL_WEST_3 = Block.box((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)12.0, (double)13.0);
    private static final VoxelShape BOWL_WEST_TAPE = Block.box((double)8.0, (double)10.0, (double)7.0, (double)11.0, (double)12.0, (double)9.0);
    private static final VoxelShape BOWL_EAST_1 = Block.box((double)3.0, (double)7.0, (double)5.0, (double)5.0, (double)12.0, (double)11.0);
    private static final VoxelShape BOWL_EAST_2 = Block.box((double)0.0, (double)12.0, (double)5.0, (double)5.0, (double)14.0, (double)11.0);
    private static final VoxelShape BOWL_EAST_3 = Block.box((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)12.0, (double)13.0);
    private static final VoxelShape BOWL_EAST_TAPE = Block.box((double)5.0, (double)10.0, (double)7.0, (double)8.0, (double)12.0, (double)9.0);
    private static final VoxelShape BOWL_NORTH = Shapes.or((VoxelShape)BASE_BOWL, (VoxelShape[])new VoxelShape[]{BOWL_NORTH_1, BOWL_NORTH_2, BOWL_NORTH_3, BOWL_NORTH_TAPE});
    private static final VoxelShape BOWL_SOUTH = Shapes.or((VoxelShape)BASE_BOWL, (VoxelShape[])new VoxelShape[]{BOWL_SOUTH_1, BOWL_SOUTH_2, BOWL_SOUTH_3, BOWL_SOUTH_TAPE});
    private static final VoxelShape BOWL_WEST = Shapes.or((VoxelShape)BASE_BOWL, (VoxelShape[])new VoxelShape[]{BOWL_WEST_1, BOWL_WEST_2, BOWL_WEST_3, BOWL_WEST_TAPE});
    private static final VoxelShape BOWL_EAST = Shapes.or((VoxelShape)BASE_BOWL, (VoxelShape[])new VoxelShape[]{BOWL_EAST_1, BOWL_EAST_2, BOWL_EAST_3, BOWL_EAST_TAPE});
    public static final EnumProperty<Part> PART = EnumProperty.create((String)"part", Part.class);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public BreedingShrineBlock(BlockBehaviour.Properties properties) {
        super(ElementType.EARTH, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)Part.CORE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<BreedingShrineBlock> codec() {
        return CODEC;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        level.setBlock(pos.relative((Direction)state.getValue((Property)FACING)), (BlockState)state.setValue(PART, (Comparable)((Object)Part.BOWL)), 3);
    }

    @NotNull
    public BlockState playerWillDestroy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        Part part;
        BlockPos blockpos;
        BlockState blockstate;
        if (!level.isClientSide && player.isCreative() && (blockstate = level.getBlockState(blockpos = pos.relative(BreedingShrineBlock.getNeighbourDirection(part = (Part)((Object)state.getValue(PART)), (Direction)state.getValue((Property)FACING))))).getBlock() == this && blockstate.getValue(PART) != part) {
            level.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Override
    @Nonnull
    public BlockState updateShape(@NotNull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (facing == BreedingShrineBlock.getNeighbourDirection((Part)((Object)state.getValue(PART)), (Direction)state.getValue((Property)FACING))) {
            return facingState.is((Block)this) && facingState.getValue(PART) != state.getValue(PART) ? state : Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    private static Direction getNeighbourDirection(Part part, Direction direction) {
        return part == Part.CORE ? direction : direction.getOpposite();
    }

    @Override
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        Direction facing = context.getHorizontalDirection();
        if (!context.getLevel().getBlockState(context.getClickedPos().relative(facing)).canBeReplaced(context)) {
            return null;
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> container) {
        container.add(new Property[]{WATERLOGGED, FACING, PART});
    }

    @Override
    public BreedingShrineBlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return state.getValue(PART) == Part.CORE ? (BreedingShrineBlockEntity)super.newBlockEntity(pos, state) : null;
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        if (state.getValue(PART) == Part.CORE) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                case Direction.NORTH -> CORE_NORTH;
                case Direction.SOUTH -> CORE_SOUTH;
                case Direction.WEST -> CORE_WEST;
                case Direction.EAST -> CORE_EAST;
                default -> BASE_CORE;
            };
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> BOWL_NORTH;
            case Direction.SOUTH -> BOWL_SOUTH;
            case Direction.WEST -> BOWL_WEST;
            case Direction.EAST -> BOWL_EAST;
            default -> BASE_BOWL;
        };
    }

    @Nonnull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Nonnull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public static enum Part implements StringRepresentable
    {
        CORE("core"),
        BOWL("bowl");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @Nonnull
        public String getSerializedName() {
            return this.name;
        }
    }
}

