/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.renderer.ECRendererHelper;
import sirttas.elementalcraft.tag.ECTags;

@OnlyIn(value=Dist.CLIENT)
public class ShrineRenderer<T extends AbstractShrineBlockEntity>
implements BlockEntityRenderer<T> {
    public void render(T shrine, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        if (((AbstractShrineBlockEntity)shrine).showsRange()) {
            BlockPos pos = shrine.getBlockPos();
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)bufferSource.getBuffer(RenderType.lines()), (AABB)((AbstractShrineBlockEntity)shrine).getRange().move((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ())), (float)1.0f, (float)1.0f, (float)0.6f, (float)1.0f);
        }
        if (Boolean.TRUE.equals(ECConfig.CLIENT.renderShrineUpgradeShadow.get())) {
            this.renderGhostUpgrades(shrine, poseStack, bufferSource);
        }
    }

    private void renderGhostUpgrades(T shrine, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource) {
        LocalPlayer player = Minecraft.getInstance().player;
        Level level = shrine.getLevel();
        if (level == null || player == null) {
            return;
        }
        BlockPos pos = shrine.getBlockPos();
        Iterator<ItemStack> iterator = List.of(player.getMainHandItem(), player.getOffhandItem()).iterator();
        boolean wasRendered = false;
        while (iterator.hasNext() && !wasRendered) {
            ItemStack stack = iterator.next();
            Item item = stack.getItem();
            if (!(item instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            if (!stack.is(ECTags.Items.SHRINE_UPGRADES)) continue;
            Block block = blockItem.getBlock();
            for (Direction direction : ((AbstractShrineBlockEntity)shrine).getUpgradeDirections()) {
                BlockState state;
                BlockPos upgradePos = pos.relative(direction);
                if (!level.getBlockState(upgradePos).isAir() || (state = block.getStateForPlacement((BlockPlaceContext)new DirectionalPlaceContext(level, upgradePos, direction.getOpposite(), stack, direction))) == null || !state.canSurvive((LevelReader)level, upgradePos)) continue;
                poseStack.pushPose();
                poseStack.translate((float)direction.getStepX(), (float)direction.getStepY(), (float)direction.getStepZ());
                ECRendererHelper.renderGhost(state, poseStack, bufferSource, level, upgradePos);
                poseStack.popPose();
                wasRendered = true;
            }
        }
    }
}

