/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine;

import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.range.Range;
import sirttas.elementalcraft.api.range.RangeVariants;
import sirttas.elementalcraft.block.anchor.TranslocationAnchorsSaveData;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.shrine.ShrineElementStorage;
import sirttas.elementalcraft.block.shrine.ShrineProperties;
import sirttas.elementalcraft.block.shrine.upgrade.AbstractShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrade;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.block.shrine.upgrade.translocation.TranslocationShrineUpgradeBlockEntity;
import sirttas.elementalcraft.component.ECDataComponents;
import sirttas.elementalcraft.range.RangeHelper;
import sirttas.elementalcraft.range.RangeRenderTimer;
import sirttas.elementalcraft.spell.Spells;
import sirttas.elementalcraft.spell.air.TranslocationSpell;

public abstract class AbstractShrineBlockEntity
extends AbstractECBlockEntity
implements IElementTypeProvider {
    protected static final List<Direction> DEFAULT_UPGRADE_DIRECTIONS = List.of(Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);
    private final Holder<IConfigurableBlockEntityProperties> properties;
    private final Map<Direction, ShrineUpgrade> upgrades = new EnumMap<Direction, ShrineUpgrade>(Direction.class);
    private final Map<ShrineUpgrade.BonusType, Float> upgradeMultipliers = new EnumMap<ShrineUpgrade.BonusType, Float>(ShrineUpgrade.BonusType.class);
    private final RangeRenderTimer rangeRenderTimer = new RangeRenderTimer();
    protected final ShrineElementStorage elementStorage = new ShrineElementStorage(this);
    private boolean running = false;
    private double tick = 0.0;
    private BlockPos targetPos;
    private AABB range;

    protected AbstractShrineBlockEntity(Supplier<? extends BlockEntityType<?>> blockEntityType, Holder<IConfigurableBlockEntityProperties> properties, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.properties = properties;
        this.targetPos = pos;
        this.range = new AABB(pos);
    }

    protected int consumeElement(int i) {
        this.running = true;
        return this.elementStorage.extractElement(i, false);
    }

    protected abstract boolean doPeriod();

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractShrineBlockEntity shrine) {
        if (!shrine.isTargetPosValid(shrine.targetPos)) {
            shrine.setChanged();
        }
        if (shrine.isDirty()) {
            shrine.refresh();
        }
        double period = shrine.getPeriod();
        int consumeAmount = shrine.getConsumeAmount();
        boolean running = shrine.running;
        if (!shrine.isPowered()) {
            shrine.tick += 1.0;
            if (period <= 0.0) {
                ElementalCraftApi.LOGGER.warn("Shrine period should not be 0, shrine: {} at {}", (Object)shrine.getBlockState().getBlock(), (Object)shrine.getBlockPos());
                period = 1.0;
            }
            while (shrine.tick >= period) {
                shrine.running = false;
                if (shrine.elementStorage.getElementAmount() >= consumeAmount && shrine.doPeriod()) {
                    shrine.consumeElement(consumeAmount);
                }
                shrine.tick -= period;
            }
        } else {
            shrine.running = false;
        }
        if (running != shrine.running) {
            shrine.setChanged();
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, AbstractShrineBlockEntity shrine) {
        shrine.rangeRenderTimer.tick();
    }

    public void refresh() {
        BlockPos blockPos = this.getBlockPos();
        if (!this.hasLevel()) {
            this.targetPos = blockPos;
            this.range = new AABB(blockPos);
            return;
        }
        this.elementStorage.refresh();
        this.upgrades.clear();
        this.upgradeMultipliers.clear();
        this.getUpgradeDirections().forEach(direction -> {
            ShrineUpgrade upgrade;
            AbstractShrineUpgradeBlock upgradeBlock;
            BlockPos pos = blockPos.relative(direction);
            BlockState state = this.level.getBlockState(pos);
            Block block = state.getBlock();
            if (block instanceof AbstractShrineUpgradeBlock && (upgradeBlock = (AbstractShrineUpgradeBlock)block).getFacing(state) == direction.getOpposite() && (upgrade = upgradeBlock.getUpgrade()) != null) {
                this.setUpgrade((Direction)direction, upgrade);
            }
        });
        this.getUpgradeDirections().forEach(direction -> {
            BlockPos pos = blockPos.relative(direction);
            BlockState state = this.level.getBlockState(pos);
            if (!state.canSurvive((LevelReader)this.level, pos)) {
                this.level.destroyBlock(pos, true);
            }
        });
        this.targetPos = this.upgrades.entrySet().stream().filter(e -> ((ShrineUpgrade)e.getValue()).is(ShrineUpgrades.TRANSLOCATION)).findFirst().flatMap(e -> BlockEntityHelper.getBlockEntityAs((BlockGetter)this.level, blockPos.relative((Direction)e.getKey()), TranslocationShrineUpgradeBlockEntity.class)).map(TranslocationShrineUpgradeBlockEntity::getTarget).filter(this::isTargetPosValid).orElse(blockPos);
        this.range = this.lookupRange();
    }

    private boolean isTargetPosValid(BlockPos p) {
        BlockPos blockPos = this.getBlockPos();
        if (blockPos.equals((Object)p)) {
            return true;
        }
        if (p == null || this.level == null) {
            return false;
        }
        if (this.level.isClientSide) {
            return true;
        }
        float maxRange = ((TranslocationSpell)Spells.TRANSLOCATION.get()).getRange(null);
        if (maxRange <= 0.0f) {
            throw new IllegalStateException("Translocation spell ranges should not be 0");
        }
        float maxRangeSq = maxRange * maxRange;
        double rangeSq = p.distSqr((Vec3i)blockPos);
        if (rangeSq > (double)maxRangeSq) {
            return false;
        }
        TranslocationAnchorsSaveData list = TranslocationAnchorsSaveData.get(this.level);
        return list != null && list.getAnchors().contains(p);
    }

    protected float getMultiplier(ShrineUpgrade.BonusType type) {
        return this.upgradeMultipliers.getOrDefault((Object)type, Float.valueOf(1.0f)).floatValue();
    }

    public int getUpgradeCount(ShrineUpgrade upgrade) {
        return upgrade == null ? 0 : (int)this.upgrades.values().stream().filter(upgrade::equals).count();
    }

    public int getUpgradeCount(ResourceKey<ShrineUpgrade> key) {
        return key == null ? 0 : (int)this.upgrades.values().stream().filter(u -> u.is(key)).count();
    }

    public boolean hasUpgrade(ShrineUpgrade upgrade) {
        return this.getUpgradeCount(upgrade) > 0;
    }

    public boolean hasUpgrade(ResourceKey<ShrineUpgrade> key) {
        return this.getUpgradeCount(key) > 0;
    }

    @Nullable
    public Direction getUpgradeDirection(ShrineUpgrade upgrade) {
        return this.getUpgradeDirection((Map.Entry<Direction, ShrineUpgrade> e) -> ((ShrineUpgrade)e.getValue()).equals(upgrade));
    }

    @Nullable
    public Direction getUpgradeDirection(ResourceKey<ShrineUpgrade> key) {
        return this.getUpgradeDirection((Map.Entry<Direction, ShrineUpgrade> e) -> ((ShrineUpgrade)e.getValue()).is(key));
    }

    @Nullable
    private Direction getUpgradeDirection(Predicate<Map.Entry<Direction, ShrineUpgrade>> predicate) {
        return this.upgrades.entrySet().stream().filter(predicate).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    private void setUpgrade(Direction direction, ShrineUpgrade upgrade) {
        ShrineUpgrade old = this.upgrades.get(direction);
        if (old != null) {
            old.getBonuses().forEach((type, bonus) -> this.upgradeMultipliers.put((ShrineUpgrade.BonusType)((Object)type), Float.valueOf(this.getMultiplier((ShrineUpgrade.BonusType)((Object)type)) / bonus.floatValue())));
        }
        this.upgrades.put(direction, upgrade);
        upgrade.getBonuses().forEach((type, bonus) -> this.upgradeMultipliers.put((ShrineUpgrade.BonusType)((Object)type), Float.valueOf(this.getMultiplier((ShrineUpgrade.BonusType)((Object)type)) * bonus.floatValue())));
    }

    public Collection<ShrineUpgrade> getAllUpgrades() {
        return this.upgrades.values();
    }

    public List<Direction> getUpgradeDirections() {
        return DEFAULT_UPGRADE_DIRECTIONS;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean showsRange() {
        return this.rangeRenderTimer.showsRange();
    }

    public void startShowingRange() {
        this.rangeRenderTimer.startShowingRange();
    }

    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    public Stream<BlockPos> getBlocksInRange() {
        return RangeHelper.getBlocksInAABB(this.getRange());
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.getProperties().getElementType();
    }

    public final AABB getRange() {
        return this.range;
    }

    protected AABB lookupRange() {
        RangeVariants ranges = this.getProperties().ranges();
        String key = "default";
        if (this.hasUpgrade(ShrineUpgrades.TRANSLOCATION) && ranges.containsKey("translocation")) {
            key = "translocation";
        } else if (!ranges.containsKey("default")) {
            return new AABB(this.getBlockPos());
        }
        return this.lookupRange(key);
    }

    protected AABB lookupRange(Direction direction) {
        return this.lookupRange(direction.getSerializedName());
    }

    protected AABB lookupRange(String key) {
        AABB box = ((Range)this.getProperties().ranges().get(key).value()).scaleBox(this.getMultiplier(ShrineUpgrade.BonusType.RANGE)).move(this.targetPos);
        double top = this.hasLevel() ? Math.min((double)this.level.getMaxBuildHeight(), box.maxY) : box.maxY;
        double bottom = this.hasLevel() ? Math.max((double)this.level.getMinBuildHeight(), box.minY) : box.minY;
        return new AABB(box.minX, bottom, box.minZ, box.maxX, top, box.maxZ);
    }

    public int getConsumeAmount() {
        return Math.round((float)this.getProperties().consumption() * this.getMultiplier(ShrineUpgrade.BonusType.ELEMENT_CONSUMPTION));
    }

    public double getPeriod() {
        return this.getProperties().period() * (double)this.getMultiplier(ShrineUpgrade.BonusType.SPEED);
    }

    @Nonnull
    public ShrineProperties getProperties() {
        Object object;
        if (this.properties.isBound() && (object = this.properties.value()) instanceof ShrineProperties) {
            ShrineProperties shrineProperties = (ShrineProperties)object;
            return shrineProperties;
        }
        return ShrineProperties.DEFAULT;
    }

    public int getCapacity() {
        return Math.round((float)this.getProperties().capacity() * this.getMultiplier(ShrineUpgrade.BonusType.CAPACITY));
    }

    public double getStrength() {
        return this.getStrength(0);
    }

    public double getStrength(int index) {
        List<Double> strength = this.getProperties().strength();
        if (strength.size() <= index) {
            ElementalCraftApi.LOGGER.warn("Shrine strength index out of bounds: {} for shrine {}", new org.apache.logging.log4j.util.Supplier[]{() -> index, () -> BuiltInRegistries.BLOCK.getKey((Object)this.getBlockState().getBlock())});
            return 1.0;
        }
        Double value = this.getProperties().strength().get(index);
        return (value != null ? value : 1.0) * (double)this.getMultiplier(ShrineUpgrade.BonusType.STRENGTH);
    }

    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (compound.contains("element_storage")) {
            this.elementStorage.deserializeNBT(provider, compound.getCompound("element_storage"));
        }
        this.running = compound.getBoolean("running");
        this.refresh();
    }

    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("element_storage", (Tag)this.elementStorage.serializeNBT(provider));
        compound.putBoolean("running", this.running);
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.elementStorage.setElementAmount((Integer)input.getOrDefault(ECDataComponents.ELEMENT_AMOUNT, (Object)0));
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ECDataComponents.ELEMENT_AMOUNT, (Object)this.elementStorage.getElementAmount());
    }

    @Deprecated
    public void removeComponentsFromTag(@NotNull CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("element_storage");
    }

    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }
}

