/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shape;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShapeHelper {
    private ShapeHelper() {
    }

    public static boolean hitCollideWithShape(VoxelShape shape, BlockPos offset, BlockHitResult hit) {
        return ShapeHelper.vectorCollideWithShape(shape, Vec3.atBottomCenterOf((Vec3i)offset), hit.getLocation());
    }

    public static boolean vectorCollideWithShape(VoxelShape shape, BlockPos offset, Vec3 vector) {
        return ShapeHelper.vectorCollideWithShape(shape, Vec3.atLowerCornerOf((Vec3i)offset), vector);
    }

    public static boolean vectorCollideWithShape(VoxelShape shape, Vec3 offset, Vec3 vector) {
        return shape.toAabbs().stream().anyMatch(a -> ShapeHelper.vectorCollideWithBoundingBox(a.move(offset), vector));
    }

    public static boolean vectorCollideWithBoundingBox(AABB box, Vec3 vector) {
        return vector.x >= box.minX && vector.x <= box.maxX && vector.y >= box.minY && vector.y <= box.maxY && vector.z >= box.minZ && vector.z <= box.maxZ;
    }

    public static Map<Direction, VoxelShape> directionShapes(VoxelShape shape) {
        return ShapeHelper.directionShapes(Direction.UP, shape);
    }

    public static Map<Direction, VoxelShape> directionShapes(Direction from, VoxelShape shape) {
        return Maps.immutableEnumMap(Map.of(Direction.UP, ShapeHelper.rotateShape(from, Direction.UP, shape), Direction.DOWN, ShapeHelper.rotateShape(from, Direction.DOWN, shape), Direction.NORTH, ShapeHelper.rotateShape(from, Direction.NORTH, shape), Direction.SOUTH, ShapeHelper.rotateShape(from, Direction.SOUTH, shape), Direction.WEST, ShapeHelper.rotateShape(from, Direction.WEST, shape), Direction.EAST, ShapeHelper.rotateShape(from, Direction.EAST, shape)));
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        if (from == to) {
            return shape;
        }
        AtomicReference<VoxelShape> result = new AtomicReference<VoxelShape>(Shapes.empty());
        shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> result.set(Shapes.or((VoxelShape)((VoxelShape)result.get()), (VoxelShape)ShapeHelper.rotateAABB(from, to, shape, minX, minY, minZ, maxX, maxY, maxZ))));
        return result.get();
    }

    private static VoxelShape rotateAABB(Direction from, Direction to, VoxelShape shape, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return switch (from) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> {
                switch (to) {
                    case DOWN: {
                        yield Shapes.box((double)minX, (double)(1.0 - maxY), (double)minZ, (double)maxX, (double)(1.0 - minY), (double)maxZ);
                    }
                    case NORTH: {
                        yield Shapes.box((double)minX, (double)minZ, (double)(1.0 - maxY), (double)maxX, (double)maxZ, (double)(1.0 - minY));
                    }
                    case SOUTH: {
                        yield Shapes.box((double)minX, (double)minZ, (double)minY, (double)maxX, (double)maxZ, (double)maxY);
                    }
                    case WEST: {
                        yield Shapes.box((double)(1.0 - maxY), (double)minX, (double)minZ, (double)(1.0 - minY), (double)maxX, (double)maxZ);
                    }
                    case EAST: {
                        yield Shapes.box((double)minY, (double)minX, (double)minZ, (double)maxY, (double)maxX, (double)maxZ);
                    }
                }
                yield shape;
            }
            case Direction.DOWN -> {
                switch (to) {
                    case UP: {
                        yield Shapes.box((double)minX, (double)(1.0 - maxY), (double)minZ, (double)maxX, (double)(1.0 - minY), (double)maxZ);
                    }
                    case NORTH: {
                        yield Shapes.box((double)minX, (double)minZ, (double)minY, (double)maxX, (double)maxZ, (double)maxY);
                    }
                    case SOUTH: {
                        yield Shapes.box((double)minX, (double)minZ, (double)(1.0 - maxY), (double)maxX, (double)maxZ, (double)(1.0 - minY));
                    }
                    case WEST: {
                        yield Shapes.box((double)minY, (double)minX, (double)minZ, (double)maxY, (double)maxX, (double)maxZ);
                    }
                    case EAST: {
                        yield Shapes.box((double)(1.0 - maxY), (double)minX, (double)minZ, (double)(1.0 - minY), (double)maxX, (double)maxZ);
                    }
                }
                yield shape;
            }
            case Direction.NORTH -> {
                switch (to) {
                    case UP: {
                        yield Shapes.box((double)minX, (double)(1.0 - maxZ), (double)minY, (double)maxX, (double)(1.0 - minZ), (double)maxY);
                    }
                    case DOWN: {
                        yield Shapes.box((double)minX, (double)minZ, (double)minY, (double)maxX, (double)maxZ, (double)maxY);
                    }
                    case SOUTH: {
                        yield Shapes.box((double)minX, (double)minY, (double)(1.0 - maxZ), (double)maxX, (double)maxY, (double)(1.0 - minZ));
                    }
                    case WEST: {
                        yield Shapes.box((double)minZ, (double)minY, (double)minX, (double)maxZ, (double)maxY, (double)maxX);
                    }
                    case EAST: {
                        yield Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX);
                    }
                }
                yield shape;
            }
            case Direction.SOUTH -> {
                switch (to) {
                    case UP: {
                        yield Shapes.box((double)minX, (double)minZ, (double)(1.0 - maxY), (double)maxX, (double)maxZ, (double)(1.0 - minY));
                    }
                    case DOWN: {
                        yield Shapes.box((double)minX, (double)minZ, (double)minY, (double)maxX, (double)maxZ, (double)maxY);
                    }
                    case NORTH: {
                        yield Shapes.box((double)minX, (double)(1.0 - maxY), (double)minZ, (double)maxX, (double)(1.0 - minY), (double)maxZ);
                    }
                    case WEST: {
                        yield Shapes.box((double)minY, (double)minX, (double)minZ, (double)maxY, (double)maxX, (double)maxZ);
                    }
                    case EAST: {
                        yield Shapes.box((double)(1.0 - maxY), (double)minX, (double)minZ, (double)(1.0 - minY), (double)maxX, (double)maxZ);
                    }
                }
                yield shape;
            }
            case Direction.WEST -> {
                switch (to) {
                    case UP: {
                        yield Shapes.box((double)minZ, (double)minX, (double)minY, (double)maxZ, (double)maxX, (double)maxY);
                    }
                    case DOWN: {
                        yield Shapes.box((double)minZ, (double)minX, (double)(1.0 - maxY), (double)maxZ, (double)maxX, (double)(1.0 - minY));
                    }
                    case NORTH: {
                        yield Shapes.box((double)minY, (double)minX, (double)minZ, (double)maxY, (double)maxX, (double)maxZ);
                    }
                    case SOUTH: {
                        yield Shapes.box((double)(1.0 - maxY), (double)minX, (double)minZ, (double)(1.0 - minY), (double)maxX, (double)maxZ);
                    }
                    case EAST: {
                        yield Shapes.box((double)minX, (double)minZ, (double)(1.0 - maxY), (double)maxX, (double)maxZ, (double)(1.0 - minY));
                    }
                }
                yield shape;
            }
            case Direction.EAST -> {
                switch (to) {
                    case UP: {
                        yield Shapes.box((double)minZ, (double)minX, (double)(1.0 - maxY), (double)maxZ, (double)maxX, (double)(1.0 - minY));
                    }
                    case DOWN: {
                        yield Shapes.box((double)minZ, (double)minX, (double)minY, (double)maxZ, (double)maxX, (double)maxY);
                    }
                    case NORTH: {
                        yield Shapes.box((double)(1.0 - maxY), (double)minX, (double)minZ, (double)(1.0 - minY), (double)maxX, (double)maxZ);
                    }
                    case SOUTH: {
                        yield Shapes.box((double)minY, (double)minX, (double)minZ, (double)maxY, (double)maxX, (double)maxZ);
                    }
                    case WEST: {
                        yield Shapes.box((double)minX, (double)minZ, (double)minY, (double)maxX, (double)maxZ, (double)maxY);
                    }
                }
                yield shape;
            }
        };
    }
}

