/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.retriever;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.sorter.ISorterBlock;
import sirttas.elementalcraft.container.ECContainerHelper;

public class RetrieverBlock
extends Block
implements ISorterBlock {
    public static final String NAME = "instrument_retriever";
    public static final MapCodec<RetrieverBlock> CODEC = RetrieverBlock.simpleCodec(RetrieverBlock::new);
    private static final VoxelShape CORE = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);

    public RetrieverBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SOURCE, (Comparable)Direction.SOUTH)).setValue((Property)TARGET, (Comparable)Direction.NORTH));
    }

    @NotNull
    protected MapCodec<RetrieverBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)SOURCE, (Comparable)direction.getOpposite())).setValue((Property)TARGET, (Comparable)direction);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> container) {
        container.add(new Property[]{SOURCE, TARGET});
    }

    @Override
    public VoxelShape getCoreShape(BlockState state) {
        return CORE;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter blockGetter, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        VoxelShape voxelShape;
        if (blockGetter instanceof Level) {
            Level level = (Level)blockGetter;
            if (level.isClientSide) {
                voxelShape = this.getShape(state, pos, Minecraft.getInstance().hitResult);
                return voxelShape;
            }
        }
        voxelShape = this.getCurrentShape(state);
        return voxelShape;
    }

    @Nonnull
    public VoxelShape getCollisionShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.getCurrentShape(state);
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        return this.moveIO(state, level, pos, hit);
    }

    public static void sendOutputToRetriever(Level level, BlockPos pos, Container inventory, int slot) {
        ItemStack stack = inventory.getItem(slot);
        if (level.hasNeighborSignal(pos) || stack.isEmpty()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockPos retrieverPos = pos.relative(direction);
            BlockState blockState = level.getBlockState(retrieverPos);
            if (!blockState.is((Block)ECBlocks.RETRIEVER.get()) || blockState.getValue((Property)SOURCE) != direction.getOpposite() || level.hasNeighborSignal(retrieverPos)) continue;
            stack = RetrieverBlock.retrieve(blockState, (BlockGetter)level, retrieverPos, stack);
            inventory.setItem(slot, stack);
            if (!stack.isEmpty()) continue;
            return;
        }
    }

    public static ItemStack retrieve(BlockState state, BlockGetter world, BlockPos pos, ItemStack output) {
        Direction direction = (Direction)state.getValue((Property)TARGET);
        return ItemHandlerHelper.insertItem((IItemHandler)ECContainerHelper.getItemHandlerAt(world, pos.relative(direction), direction.getOpposite()), (ItemStack)output, (boolean)false);
    }
}

