/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pureinfuser.pedestal;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.entity.AbstractIERBlockEntity;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.pureinfuser.pedestal.PedestalElementStorage;
import sirttas.elementalcraft.component.ECDataComponents;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.container.SingleItemContainer;
import sirttas.elementalcraft.recipe.input.SingleItemSingleElementRecipeInput;

public class PedestalBlockEntity
extends AbstractIERBlockEntity
implements IElementTypeProvider {
    private final SingleItemContainer inventory = new SingleItemContainer(this::setChanged);
    private final PedestalElementStorage elementStorage;
    private final RuneHandler runeHandler;

    public PedestalBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.PEDESTAL, pos, state);
        this.elementStorage = new PedestalElementStorage(ElementType.getElementType(state), this::setChanged);
        this.runeHandler = new RuneHandler((Integer)ECConfig.SERVER.pedestalMaxRunes.get(), this::setChanged);
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.elementStorage.getElementType();
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.inventory;
    }

    public ItemStack getItem() {
        return this.inventory.getItem(0);
    }

    @Override
    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }

    @Override
    @Nonnull
    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.elementStorage.setElementAmount((Integer)input.getOrDefault(ECDataComponents.ELEMENT_AMOUNT, (Object)0));
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ECDataComponents.ELEMENT_AMOUNT, (Object)this.elementStorage.getElementAmount());
    }

    @Deprecated
    public void removeComponentsFromTag(@NotNull CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("element_storage");
    }

    public SingleItemSingleElementRecipeInput createRecipeInput() {
        return new SingleItemSingleElementRecipeInput(this.getItem(), this.getElementType(), this.getElementStorage().getElementAmount());
    }
}

