/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pureinfuser.pedestal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.pipe.IPipeConnectedBlock;
import sirttas.elementalcraft.block.pureinfuser.pedestal.PedestalBlockEntity;

public class PedestalBlock
extends AbstractECContainerBlock
implements IElementTypeProvider,
IPipeConnectedBlock {
    private static final VoxelShape BASE_1 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape BASE_2 = Block.box((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
    private static final VoxelShape BASE_3 = Block.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape CONNECTOR_NORTH = Block.box((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)2.0);
    private static final VoxelShape CONNECTOR_SOUTH = Block.box((double)7.0, (double)7.0, (double)14.0, (double)9.0, (double)9.0, (double)16.0);
    private static final VoxelShape CONNECTOR_WEST = Block.box((double)0.0, (double)7.0, (double)7.0, (double)2.0, (double)9.0, (double)9.0);
    private static final VoxelShape CONNECTOR_EAST = Block.box((double)14.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    private static final VoxelShape BASE = Shapes.or((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{BASE_2, BASE_3});
    private static final VoxelShape AIR = Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), (VoxelShape[])new VoxelShape[]{BASE_2, BASE_3});
    private static final VoxelShape EARTH = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)3.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)3.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0)});
    public static final String NAME = "pedestal";
    public static final String NAME_FIRE = "pedestal_fire";
    public static final String NAME_WATER = "pedestal_water";
    public static final String NAME_EARTH = "pedestal_earth";
    public static final String NAME_AIR = "pedestal_air";
    public static final MapCodec<PedestalBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(ElementType.forGetter(PedestalBlock::getElementType), (App)PedestalBlock.propertiesCodec()).apply((Applicative)instance, PedestalBlock::new));
    private final ElementType elementType;

    public PedestalBlock(ElementType elementType, BlockBehaviour.Properties properties) {
        super(properties);
        this.elementType = elementType;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<PedestalBlock> codec() {
        return CODEC;
    }

    public PedestalBlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return this.getElementType() != ElementType.NONE ? new PedestalBlockEntity(pos, state) : null;
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        return this.onSingleSlotActivated(stack, level, pos, player, hand);
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        VoxelShape shape = this.getBaseShape();
        if (Boolean.TRUE.equals(state.getValue((Property)NORTH))) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTOR_NORTH);
        }
        if (Boolean.TRUE.equals(state.getValue((Property)SOUTH))) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTOR_SOUTH);
        }
        if (Boolean.TRUE.equals(state.getValue((Property)EAST))) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTOR_EAST);
        }
        if (Boolean.TRUE.equals(state.getValue((Property)WEST))) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTOR_WEST);
        }
        return shape;
    }

    private VoxelShape getBaseShape() {
        if (this.elementType == ElementType.AIR) {
            return AIR;
        }
        if (this.elementType == ElementType.EARTH) {
            return EARTH;
        }
        return BASE;
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.elementType;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> container) {
        container.add(new Property[]{NORTH, SOUTH, EAST, WEST});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.doGetStateForPlacement((BlockGetter)context.getLevel(), context.getClickedPos());
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        return this.doUpdateShape(state, (BlockGetter)level, currentPos, facing);
    }
}

