/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pureinfuser;

import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.crafting.AbstractECCraftingBlockEntity;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.pureinfuser.pedestal.PedestalBlockEntity;
import sirttas.elementalcraft.container.SingleItemContainer;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.recipe.input.SingleItemSingleElementRecipeInput;
import sirttas.elementalcraft.recipe.pure.infusion.PureInfusionRecipe;
import sirttas.elementalcraft.recipe.pure.infusion.PureInfusionRecipeInput;

public class PureInfuserBlockEntity
extends AbstractECCraftingBlockEntity<PureInfusionRecipeInput, PureInfusionRecipe> {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("pure_infuser");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);
    private final SingleItemContainer inventory = new SingleItemContainer(this::setChanged);
    private final Map<Direction, PedestalWrapper> pedestalWrappers = new EnumMap<Direction, PedestalWrapper>(Direction.class);

    public PureInfuserBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.PURE_INFUSER, PROPERTIES, pos, state);
        this.pedestalWrappers.put(Direction.NORTH, new PedestalWrapper(Direction.NORTH));
        this.pedestalWrappers.put(Direction.SOUTH, new PedestalWrapper(Direction.SOUTH));
        this.pedestalWrappers.put(Direction.WEST, new PedestalWrapper(Direction.WEST));
        this.pedestalWrappers.put(Direction.EAST, new PedestalWrapper(Direction.EAST));
    }

    @Override
    public void process() {
        super.process();
        if (this.level.isClientSide) {
            ParticleHelper.createCraftingParticle(ElementType.NONE, this.level, Vec3.atCenterOf((Vec3i)this.worldPosition).add(0.0, 0.7, 0.0), this.level.random);
        }
    }

    @Override
    @NotNull
    protected PureInfusionRecipeInput createRecipeInput() {
        return new PureInfusionRecipeInput(this.pedestalWrappers.values().stream().map(p -> p.pedestal.createRecipeInput()).collect(Collectors.toMap(SingleItemSingleElementRecipeInput::getElementType, Function.identity(), (i1, i2) -> i1)), this.getItem());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PureInfuserBlockEntity pureInfuser) {
        pureInfuser.refreshPedestals();
        if (!pureInfuser.isPowered()) {
            pureInfuser.makeProgress();
        }
        AbstractECCraftingBlockEntity.tick(pureInfuser);
    }

    @VisibleForTesting
    public void refreshPedestals() {
        this.pedestalWrappers.forEach((d, w) -> {
            if (w.isRemoved()) {
                w.lookupPedestal();
            }
        });
    }

    protected void makeProgress() {
        if (this.recipe != null && this.pedestalWrappers.values().stream().allMatch(w -> !w.isRemoved() && w.progress >= ((PureInfusionRecipe)this.recipe).getElementAmount())) {
            this.process();
            this.resetProgress();
        } else if (this.isRecipeAvailable()) {
            this.pedestalWrappers.forEach(this::makeProgress);
        } else if (this.recipe == null) {
            this.resetProgress();
        }
    }

    @Override
    public boolean isRecipeAvailable() {
        if (this.pedestalWrappers.values().stream().anyMatch(w -> w.getElementType() == ElementType.NONE)) {
            return false;
        }
        return super.isRecipeAvailable();
    }

    private void resetProgress() {
        this.pedestalWrappers.values().forEach(w -> {
            w.progress = 0;
        });
    }

    @VisibleForTesting
    public PedestalBlockEntity getPedestal(ElementType type) {
        if (type == ElementType.NONE) {
            return null;
        }
        return this.pedestalWrappers.values().stream().filter(w -> w.getElementType() == type).map(w -> w.pedestal).findFirst().orElse(null);
    }

    public ElementType getPedestalElementType(Direction direction) {
        return this.pedestalWrappers.get(direction).getElementType();
    }

    private void makeProgress(Direction direction, PedestalWrapper wrapper) {
        if (wrapper.isRemoved()) {
            return;
        }
        ElementType type = wrapper.getElementType();
        if (type == ElementType.NONE) {
            return;
        }
        PedestalBlockEntity pedestal = wrapper.pedestal;
        Direction offset = direction.getOpposite();
        int oldProgress = wrapper.progress;
        float transferAmount = Math.min(this.getTransferSpeed(pedestal), (float)((PureInfusionRecipe)this.recipe).getElementAmount() - (float)oldProgress);
        if (transferAmount <= 0.0f) {
            return;
        }
        float preservation = this.runeHandler.getBonus(Rune.BonusType.ELEMENT_PRESERVATION) + pedestal.getRuneHandler().getBonus(Rune.BonusType.ELEMENT_PRESERVATION) + 1.0f;
        float newProgress = (float)oldProgress + (float)pedestal.getElementStorage().extractElement(Math.max(1, Math.round(transferAmount / preservation)), false) * preservation;
        wrapper.progress = Math.round(newProgress);
        if (this.level != null && this.level.isClientSide && newProgress > 0.0f && this.getProgressRounded(transferAmount, newProgress) > this.getProgressRounded(transferAmount, oldProgress)) {
            ParticleHelper.createElementFlowParticle(type, this.level, Vec3.atCenterOf((Vec3i)this.worldPosition).add(0.0, 0.7, 0.0), offset, 2.5f, this.level.random);
        } else if (this.level != null && !this.level.isClientSide) {
            this.setChanged();
        }
    }

    @Override
    public void assemble() {
        this.inventory.setItem(0, ((PureInfusionRecipe)this.recipe).assemble(this.createRecipeInput(), (HolderLookup.Provider)this.level.registryAccess()));
        this.pedestalWrappers.values().forEach(w -> w.setPedestalInventory(w.pedestal.getItem().getCraftingRemainingItem()));
    }

    private float getTransferSpeed(PedestalBlockEntity pedestal) {
        return this.getTransferSpeed() * (this.runeHandler.getBonus(Rune.BonusType.SPEED) + pedestal.getRuneHandler().getBonus(Rune.BonusType.SPEED) + 1.0f);
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.inventory;
    }

    public ItemStack getItem() {
        return this.inventory.getItem(0);
    }

    @Override
    public boolean isRunning() {
        return this.pedestalWrappers.values().stream().anyMatch(w -> !w.isRemoved() && w.progress > 0);
    }

    @Override
    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        int[] progressArray = compound.getIntArray("progress");
        for (int i = 0; i < progressArray.length; ++i) {
            Direction direction = Direction.from2DDataValue((int)i);
            this.pedestalWrappers.get((Object)direction).progress = progressArray[i];
        }
    }

    @Override
    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putIntArray("progress", this.pedestalWrappers.entrySet().stream().sorted(Comparator.comparingInt(e -> ((Direction)e.getKey()).get2DDataValue())).mapToInt(e -> ((PedestalWrapper)e.getValue()).progress).toArray());
    }

    private class PedestalWrapper
    implements IElementTypeProvider {
        private final Direction direction;
        private PedestalBlockEntity pedestal;
        private int progress;

        public PedestalWrapper(Direction direction) {
            this.direction = direction;
            this.pedestal = null;
            this.progress = 0;
        }

        public boolean isRemoved() {
            return this.pedestal == null || this.pedestal.isRemoved();
        }

        @Override
        @NotNull
        public ElementType getElementType() {
            return this.isRemoved() ? ElementType.NONE : this.pedestal.getElementType();
        }

        public void lookupPedestal() {
            PedestalBlockEntity p;
            BlockEntity be = PureInfuserBlockEntity.this.level != null ? PureInfuserBlockEntity.this.level.getBlockEntity(PureInfuserBlockEntity.this.worldPosition.relative(this.direction, 3)) : null;
            this.pedestal = be instanceof PedestalBlockEntity ? (p = (PedestalBlockEntity)be) : null;
        }

        public void setPedestalInventory(ItemStack stack) {
            if (this.isRemoved()) {
                return;
            }
            this.pedestal.getInventory().setItem(0, stack);
            this.pedestal.setChanged();
        }
    }
}

