/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe.upgrade.valve;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.upgrade.renderer.IPipeUpgradeRenderer;
import sirttas.elementalcraft.block.pipe.upgrade.valve.ElementValvePipeUpgrade;
import sirttas.elementalcraft.client.model.ECModelHelper;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class ElementValvePipeUpgradeRenderer
implements IPipeUpgradeRenderer<ElementValvePipeUpgrade> {
    public static final ModelResourceLocation OPEN_LOCATION = ECModelHelper.standalone("elementalcraft/pipe_upgrades/element_valve_open");
    public static final ModelResourceLocation CLOSE_LOCATION = ECModelHelper.standalone("elementalcraft/pipe_upgrades/element_valve_close");
    private BakedModel openModel;
    private BakedModel closeModel;

    @Override
    public void render(ElementValvePipeUpgrade upgrade, ElementPipeBlockEntity pipe, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        if (this.openModel == null || this.closeModel == null) {
            ModelManager modelManager = Minecraft.getInstance().getModelManager();
            this.openModel = modelManager.getModel(OPEN_LOCATION);
            this.closeModel = modelManager.getModel(CLOSE_LOCATION);
        }
        if (upgrade.isOpen()) {
            ECRendererHelper.renderModel(this.openModel, poseStack, buffer, pipe, light, overlay);
            ElementValvePipeUpgradeRenderer.renderParticles(upgrade, pipe);
        } else {
            ECRendererHelper.renderModel(this.closeModel, poseStack, buffer, pipe, light, overlay);
        }
    }

    private static void renderParticles(ElementValvePipeUpgrade upgrade, ElementPipeBlockEntity pipe) {
        Level level = pipe.getLevel();
        if (level == null) {
            return;
        }
        RandomSource random = level.random;
        if (random.nextFloat() >= 0.01f) {
            return;
        }
        Direction direction = upgrade.getDirection();
        BlockPos pos = pipe.getBlockPos();
        float f = -0.28125f;
        double x = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 0.2 - (double)(f * (float)direction.getStepX());
        double y = (double)pos.getY() + 0.5 + (random.nextDouble() - 0.5) * 0.2 - (double)(f * (float)direction.getStepY());
        double z = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 0.2 - (double)(f * (float)direction.getStepZ());
        level.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, x, y, z, 0.0, 0.0, 0.0);
    }
}

