/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe.upgrade.type;

import javax.annotation.Nonnull;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgrade;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgradeModelShaper;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeTypes;
import sirttas.elementalcraft.client.model.ECModelShapers;

public class PipeUpgradeType<T extends PipeUpgrade>
implements ItemLike {
    public final Factory<T> factory;
    private Item item;
    private ResourceLocation key;
    private String descriptionId;
    private ResourceKey<LootTable> lootTable;
    @OnlyIn(value=Dist.CLIENT)
    private BakedModel model;

    public PipeUpgradeType(Factory<T> factory) {
        this.factory = factory;
    }

    public T create(ElementPipeBlockEntity pipe, Direction direction) {
        return this.factory.create(pipe, direction);
    }

    @Nonnull
    public Item asItem() {
        if (this.item == null) {
            this.item = PipeUpgradeTypes.getUpgradeItem(this);
        }
        return this.item;
    }

    @Nonnull
    public ResourceLocation getKey() {
        if (this.key == null) {
            this.key = PipeUpgradeTypes.REGISTRY.getKey((Object)this);
        }
        if (this.key == null) {
            throw new IllegalStateException("PipeUpgradeType " + String.valueOf(this) + " is missing a registry name!");
        }
        return this.key;
    }

    @Nonnull
    public String getDescriptionId() {
        if (this.descriptionId == null) {
            ResourceLocation id = this.getKey();
            this.descriptionId = "elementalcraft.pipe_upgrade." + id.getNamespace() + "." + id.getPath();
        }
        return this.descriptionId;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public BakedModel getModel() {
        if (this.model == null) {
            this.model = ECModelShapers.get(PipeUpgradeModelShaper.NAME).getBlockModel(this);
        }
        return this.model;
    }

    public ResourceKey<LootTable> getLootTable() {
        if (this.lootTable == null) {
            ResourceLocation k = this.getKey();
            this.lootTable = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)k.getNamespace(), (String)("elementalcraft/pipe_upgrades/" + k.getPath())));
        }
        return this.lootTable;
    }

    @FunctionalInterface
    public static interface Factory<T extends PipeUpgrade> {
        public T create(ElementPipeBlockEntity var1, Direction var2);
    }
}

