/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe.upgrade.renderer;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredHolder;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgrade;
import sirttas.elementalcraft.block.pipe.upgrade.beam.ElementBeamPipeUpgradeRenderer;
import sirttas.elementalcraft.block.pipe.upgrade.pump.ElementPumpPipeUpgradeRenderer;
import sirttas.elementalcraft.block.pipe.upgrade.renderer.IPipeUpgradeRenderer;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeType;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeTypes;
import sirttas.elementalcraft.block.pipe.upgrade.valve.ElementValvePipeUpgradeRenderer;

public class PipeUpgradeRenderers {
    private static final Map<ResourceLocation, IPipeUpgradeRenderer<?>> RENDERERS = new HashMap();

    private PipeUpgradeRenderers() {
    }

    public static <T extends PipeUpgrade> IPipeUpgradeRenderer<T> get(T upgrade) {
        return PipeUpgradeRenderers.get(upgrade.getType());
    }

    public static <T extends PipeUpgrade> IPipeUpgradeRenderer<T> get(PipeUpgradeType<T> type) {
        return RENDERERS.get(type.getKey());
    }

    public static <T extends PipeUpgrade> void register(DeferredHolder<PipeUpgradeType<?>, ? extends PipeUpgradeType<T>> type, IPipeUpgradeRenderer<T> renderer) {
        RENDERERS.put(type.getId(), renderer);
    }

    static {
        PipeUpgradeRenderers.register(PipeUpgradeTypes.ELEMENT_VALVE, new ElementValvePipeUpgradeRenderer());
        PipeUpgradeRenderers.register(PipeUpgradeTypes.ELEMENT_BEAM, new ElementBeamPipeUpgradeRenderer());
        PipeUpgradeRenderers.register(PipeUpgradeTypes.ELEMENT_PUMP, new ElementPumpPipeUpgradeRenderer());
    }
}

