/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe.upgrade.capability;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.CapabilityRegistry;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.ApiStatus;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgrade;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeType;

public class PipeUpgradeCapability<T, C>
extends BaseCapability<T, C> {
    private static final CapabilityRegistry<PipeUpgradeCapability<?, ?>> registry = new CapabilityRegistry(PipeUpgradeCapability::new);
    final Map<PipeUpgradeType<?>, List<ICapabilityProvider<PipeUpgrade, C, T>>> providers = new IdentityHashMap();

    private PipeUpgradeCapability(ResourceLocation name, Class<T> typeClass, Class<C> contextClass) {
        super(name, typeClass, contextClass);
    }

    public static <T, C> PipeUpgradeCapability<T, C> create(ResourceLocation name, Class<T> typeClass, Class<C> contextClass) {
        return (PipeUpgradeCapability)((Object)registry.create(name, typeClass, contextClass));
    }

    public static <T> PipeUpgradeCapability<T, Void> createVoid(ResourceLocation name, Class<T> typeClass) {
        return PipeUpgradeCapability.create(name, typeClass, Void.TYPE);
    }

    public static <T> PipeUpgradeCapability<T, Direction> createSided(ResourceLocation name, Class<T> typeClass) {
        return PipeUpgradeCapability.create(name, typeClass, Direction.class);
    }

    public static synchronized List<PipeUpgradeCapability<?, ?>> getAll() {
        return registry.getAll();
    }

    public <B extends ElementPipeBlockEntity> ICapabilityProvider<? super B, Direction, T> getBlockCapabilityProvider() {
        return (pipe, direction) -> {
            PipeUpgrade upgrade = pipe.getUpgrade((Direction)direction);
            if (upgrade != null) {
                return this.getCapability(upgrade, null);
            }
            return null;
        };
    }

    @Nullable
    @ApiStatus.Internal
    public T getCapability(PipeUpgrade pipeUpgrade, C context) {
        for (ICapabilityProvider provider : this.providers.getOrDefault(pipeUpgrade.getType(), List.of())) {
            Object ret = provider.getCapability((Object)pipeUpgrade, context);
            if (ret == null) continue;
            return (T)ret;
        }
        return null;
    }
}

