/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe.upgrade.beam;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.transfer.IElementTransferer;
import sirttas.elementalcraft.api.element.transfer.path.IElementTransferPathNode;
import sirttas.elementalcraft.block.pipe.ConnectionType;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.ElementPipeTransferer;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgrade;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeType;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeTypes;
import sirttas.elementalcraft.block.shape.ShapeHelper;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.particle.ParticleHelper;

public class ElementBeamPipeUpgrade
extends PipeUpgrade {
    public static final String NAME = "element_beam";
    private static final Map<Direction, VoxelShape> SHAPES = ShapeHelper.directionShapes(Block.box((double)7.0, (double)9.5, (double)7.0, (double)9.0, (double)14.0, (double)9.0));
    private ElementBeamPipeUpgrade other;
    private int transfered = 0;

    public ElementBeamPipeUpgrade(ElementPipeBlockEntity pipe, Direction direction) {
        super((PipeUpgradeType)PipeUpgradeTypes.ELEMENT_BEAM.get(), pipe, direction);
    }

    @Override
    public VoxelShape getShape() {
        return SHAPES.get(this.getDirection());
    }

    @Override
    public boolean replaceSection() {
        return true;
    }

    @Override
    public boolean canPlace(ConnectionType connectionType) {
        return !connectionType.isConnected();
    }

    public boolean isLinked() {
        this.tryLink();
        return this.other != null;
    }

    @Override
    public List<BlockPos> getConnections(ElementType type, ConnectionType connection) {
        this.tryLink();
        return this.other != null ? Collections.singletonList(this.other.getPipe().getBlockPos()) : Collections.emptyList();
    }

    @Override
    public boolean canTransfer(ElementType type, ConnectionType connection) {
        this.tryLink();
        return this.other != null;
    }

    @Override
    public void onAdded() {
        this.tryLink();
    }

    private void tryLink() {
        if (this.other == null) {
            this.findOther().ifPresent(b -> {
                Optional<ElementBeamPipeUpgrade> opt = b.findOther();
                if (opt.isPresent() && opt.get() == this) {
                    this.other = b;
                    b.other = this;
                }
            });
        }
    }

    @Override
    public void onRemoved() {
        if (this.other != null) {
            this.other.other = null;
            this.other = null;
        }
    }

    @Override
    public int getWeight() {
        return (int)Math.round(Math.floor(Math.sqrt(this.getPipe().getBlockPos().distSqr((Vec3i)this.other.getPipe().getBlockPos())) / 2.0));
    }

    @Override
    public void onTransfer(ElementType type, int amount, @Nullable IElementTransferPathNode prev, @Nullable IElementTransferPathNode next) {
        BlockPos to;
        ElementPipeBlockEntity pipe = this.getPipe();
        Level level = pipe.getLevel();
        ElementPipeBlockEntity otherPipe = this.other != null ? this.other.getPipe() : null;
        BlockPos blockPos = to = next != null ? next.getPos() : null;
        if (level == null || otherPipe == null || !otherPipe.getBlockPos().equals((Object)to) || pipe.isCovered() || otherPipe.isCovered()) {
            return;
        }
        int max = pipe.getMaxTransferAmount();
        this.transfered += amount;
        if (this.transfered < max) {
            return;
        }
        this.transfered -= max;
        if (level.random.nextDouble() < 0.2) {
            Direction direction = this.getDirection();
            Direction opposite = direction.getOpposite();
            ParticleHelper.createElementFlowParticle(type, level, Vec3.atCenterOf((Vec3i)to).relative(opposite, 0.5), Vec3.atCenterOf((Vec3i)pipe.getBlockPos()).relative(direction, 0.5), level.random);
        }
    }

    private Optional<ElementBeamPipeUpgrade> findOther() {
        ElementPipeBlockEntity pipe = this.getPipe();
        Level level = pipe.getLevel();
        if (level == null) {
            return Optional.empty();
        }
        BlockPos.MutableBlockPos pos = pipe.getBlockPos().mutable();
        Direction direction = this.getDirection();
        Direction opposite = direction.getOpposite();
        int range = (Integer)ECConfig.SERVER.elementBeamRange.get();
        for (int i = 0; i < range; ++i) {
            ElementPipeTransferer elementPipeTransferer;
            PipeUpgrade pipeUpgrade;
            IElementTransferer transferer = (IElementTransferer)level.getCapability(ElementalCraftCapabilities.ElementTransferer.BLOCK, (BlockPos)pos.move(direction), (Object)opposite);
            if (!(transferer instanceof ElementPipeTransferer) || !((pipeUpgrade = (elementPipeTransferer = (ElementPipeTransferer)transferer).getUpgrade(opposite)) instanceof ElementBeamPipeUpgrade)) continue;
            ElementBeamPipeUpgrade elementBeamPipeUpgrade = (ElementBeamPipeUpgrade)pipeUpgrade;
            return Optional.of(elementBeamPipeUpgrade);
        }
        return Optional.empty();
    }
}

