/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe.upgrade;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.attachment.AttachmentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.transfer.path.IElementTransferPath;
import sirttas.elementalcraft.api.element.transfer.path.IElementTransferPathNode;
import sirttas.elementalcraft.block.pipe.ConnectionType;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.ElementPipeTransferer;
import sirttas.elementalcraft.block.pipe.upgrade.capability.PipeUpgradeCapability;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeType;
import sirttas.elementalcraft.loot.parameter.ECLootContextParamSets;
import sirttas.elementalcraft.loot.parameter.ECLootContextParams;

public class PipeUpgrade
extends AttachmentHolder
implements ItemLike {
    public static final String FOLDER = "elementalcraft/pipe_upgrades/";
    private final PipeUpgradeType<?> type;
    private final ElementPipeBlockEntity pipe;
    private final Direction direction;
    private Item item;

    protected PipeUpgrade(PipeUpgradeType<?> type, ElementPipeBlockEntity pipe, Direction direction) {
        this.type = type;
        this.pipe = pipe;
        this.direction = direction;
    }

    @Nullable
    public final <T> T setData(@NotNull AttachmentType<T> type, @NotNull T data) {
        this.pipe.setChanged();
        return (T)super.setData(type, data);
    }

    @Nullable
    public <T, C> T getCapability(@NotNull PipeUpgradeCapability<T, C> cap, C context) {
        return cap.getCapability(this, context);
    }

    public ResourceLocation getKey() {
        return this.type.getKey();
    }

    public final void load(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains("neoforge:attachments", 10)) {
            this.deserializeAttachments(provider, tag.getCompound("neoforge:attachments"));
        }
        this.loadAdditional(tag, provider);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
    }

    public final CompoundTag save(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        CompoundTag attachments = this.serializeAttachments(provider);
        tag.putString("id", this.getKey().toString());
        if (attachments != null) {
            tag.put("neoforge:attachments", (Tag)attachments);
        }
        this.saveAdditional(tag, provider);
        return tag;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
    }

    @Nonnull
    public PipeUpgradeType<?> getType() {
        return this.type;
    }

    @Nonnull
    public Direction getDirection() {
        return this.direction;
    }

    @Nonnull
    public ElementPipeBlockEntity getPipe() {
        return this.pipe;
    }

    public void onAdded() {
    }

    public void onRemoved() {
    }

    public void onTransfer(ElementType type, int amount, @Nullable IElementTransferPathNode prev, @Nullable IElementTransferPathNode next) {
    }

    public boolean canPlace(ConnectionType connectionType) {
        return connectionType.isConnected();
    }

    public boolean canTransfer(ElementType type, ConnectionType connection) {
        return true;
    }

    public VoxelShape getShape() {
        return Shapes.empty();
    }

    public boolean replaceSection() {
        return false;
    }

    public boolean replaceExtraction() {
        return this.replaceSection();
    }

    public List<BlockPos> getConnections(ElementType type, ConnectionType connection) {
        return this.canTransfer(type, connection) ? ElementPipeTransferer.getDefaultPos(this.pipe.getBlockPos(), this.direction, connection) : Collections.emptyList();
    }

    public IElementTransferPath alterPath(@Nonnull IElementTransferPath path) {
        return path;
    }

    @Nonnull
    public RenderShape getRenderShape() {
        return RenderShape.MODEL;
    }

    public void dropAll(@Nullable Player player) {
        ServerLevel serverLevel;
        block5: {
            block4: {
                Level level = this.pipe.getLevel();
                if (!(level instanceof ServerLevel)) break block4;
                serverLevel = (ServerLevel)level;
                if (!serverLevel.isClientSide) break block5;
            }
            return;
        }
        ResourceKey<LootTable> tableKey = this.type.getLootTable();
        if (tableKey.equals((Object)BuiltInLootTables.EMPTY)) {
            return;
        }
        LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.BLOCK_STATE, (Object)this.pipe.getBlockState()).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)this.pipe.getBlockPos())).withParameter(ECLootContextParams.DIRECTION, (Object)this.direction).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)this.pipe).create(ECLootContextParamSets.PIPE_UPGRADE);
        serverLevel.getServer().reloadableRegistries().getLootTable(tableKey).getRandomItems(lootParams).forEach(player != null ? arg_0 -> ((Player)player).spawnAtLocation(arg_0) : stack -> Containers.dropItemStack((Level)serverLevel, (double)this.pipe.getBlockPos().getX(), (double)this.pipe.getBlockPos().getY(), (double)this.pipe.getBlockPos().getZ(), (ItemStack)stack));
    }

    @Nonnull
    public Item asItem() {
        if (this.item == null) {
            this.item = this.type.asItem();
        }
        return this.item;
    }

    public int getWeight() {
        return 0;
    }
}

