/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.transfer.IElementTransferer;
import sirttas.elementalcraft.block.pipe.ConnectionType;
import sirttas.elementalcraft.block.pipe.ElementPipeTransferer;

public interface IPipeConnectedBlock {
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;

    default public BlockState doGetStateForPlacement(BlockGetter level, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((Block)this).defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(level, pos, Direction.NORTH)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(level, pos, Direction.SOUTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(level, pos, Direction.EAST)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(level, pos, Direction.WEST)));
    }

    default public BlockState doUpdateShape(BlockState state, BlockGetter level, BlockPos pos, Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> (BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(level, pos, Direction.NORTH)));
            case Direction.SOUTH -> (BlockState)state.setValue((Property)SOUTH, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(level, pos, Direction.SOUTH)));
            case Direction.EAST -> (BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(level, pos, Direction.EAST)));
            case Direction.WEST -> (BlockState)state.setValue((Property)WEST, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(level, pos, Direction.WEST)));
            default -> state;
        };
    }

    public static boolean isConnectable(BlockGetter level, BlockPos from, Direction face) {
        if (!(level instanceof Level)) {
            return false;
        }
        Level l = (Level)level;
        Direction opposite = face.getOpposite();
        BlockPos pos = from.relative(face);
        IElementTransferer transferer = (IElementTransferer)l.getCapability(ElementalCraftCapabilities.ElementTransferer.BLOCK, pos, (Object)opposite);
        if (transferer instanceof ElementPipeTransferer) {
            ElementPipeTransferer elementPipeTransferer = (ElementPipeTransferer)transferer;
            ConnectionType connection = elementPipeTransferer.getConnection(opposite);
            return connection.isConnected() || connection == ConnectionType.NONE;
        }
        return false;
    }
}

