/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.transfer.IElementTransferer;
import sirttas.elementalcraft.api.element.transfer.path.IElementTransferPathNode;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.pipe.ConnectionType;
import sirttas.elementalcraft.block.pipe.ElementPipeBlock;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgrade;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgradeHelper;
import sirttas.elementalcraft.config.ECConfig;

@EventBusSubscriber(modid="elementalcraft")
public class ElementPipeTransferer
implements IElementTransferer,
INBTSerializable<CompoundTag> {
    private static final Collection<ElementPipeTransferer> TRANSFERERS = new ReferenceOpenHashSet();
    final ElementPipeBlockEntity pipe;
    final Map<Direction, ConnectionType> connections;
    final Map<Direction, PipeUpgrade> upgrades;
    final int maxTransferAmount;
    private boolean initialized;
    int transferedAmount;

    ElementPipeTransferer(ElementPipeBlockEntity pipe) {
        this.pipe = pipe;
        this.initialized = false;
        this.connections = new EnumMap<Direction, ConnectionType>(Direction.class);
        for (Direction direction : Direction.values()) {
            this.connections.put(direction, ConnectionType.NONE);
        }
        this.upgrades = new EnumMap<Direction, PipeUpgrade>(Direction.class);
        this.maxTransferAmount = switch (((ElementPipeBlock)pipe.getBlockState().getBlock()).getType()) {
            default -> throw new MatchException(null, null);
            case ElementPipeBlock.PipeType.RUDIMENTARY -> (Integer)ECConfig.SERVER.rudimentaryPipeTransferAmount.get();
            case ElementPipeBlock.PipeType.STANDARD -> (Integer)ECConfig.SERVER.pipeTransferAmount.get();
            case ElementPipeBlock.PipeType.IMPROVED -> (Integer)ECConfig.SERVER.improvedPipeTransferAmount.get();
            case ElementPipeBlock.PipeType.CREATIVE -> Integer.MAX_VALUE;
        };
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        Iterator<ElementPipeTransferer> it = TRANSFERERS.iterator();
        while (it.hasNext()) {
            ElementPipeTransferer transferer = it.next();
            if (transferer.pipe.isRemoved()) {
                it.remove();
                continue;
            }
            transferer.transferedAmount = 0;
        }
    }

    public int getUpgradeWeight(Direction face) {
        PipeUpgrade upgrade = this.getUpgrade(face);
        if (upgrade == null) {
            return 0;
        }
        return upgrade.getWeight();
    }

    public ConnectionType getConnection(Direction face) {
        return this.connections.getOrDefault(face, ConnectionType.NONE);
    }

    public Map<Direction, ConnectionType> getConnections() {
        return this.connections;
    }

    synchronized void init() {
        if (this.initialized) {
            return;
        }
        Level level = this.pipe.getLevel();
        if (level == null || level.isClientSide()) {
            return;
        }
        if (!this.pipe.getBlockState().is((Block)ECBlocks.PIPE_CREATIVE.get())) {
            TRANSFERERS.add(this);
        }
        this.initialized = true;
    }

    @Override
    public List<IElementTransferPathNode> getConnectedNodes(@Nonnull ElementType type) {
        Level level = this.pipe.getLevel();
        if (level == null) {
            return Collections.emptyList();
        }
        BlockPos pipePos = this.pipe.getBlockPos();
        return this.connections.entrySet().stream().mapMulti((entry, downstream) -> {
            List<BlockPos> foundConnections;
            Direction side = (Direction)entry.getKey();
            Direction opposite = side.getOpposite();
            ConnectionType connection = (ConnectionType)((Object)((Object)entry.getValue()));
            PipeUpgrade upgrade = this.getUpgrade(side);
            List<BlockPos> list = foundConnections = upgrade != null ? upgrade.getConnections(type, connection) : ElementPipeTransferer.getDefaultPos(pipePos, side, connection);
            if (foundConnections.isEmpty()) {
                return;
            }
            foundConnections.forEach(p -> downstream.accept(this.createNode(level, (BlockPos)p, type, opposite, connection)));
        }).toList();
    }

    public IElementTransferPathNode createNode(Level level, BlockPos pos, ElementType type, Direction side, ConnectionType connection) {
        IElementStorage storage;
        ElementPipeTransferer elementPipeTransferer;
        PipeUpgrade upgrade;
        IElementTransferer transferer = (IElementTransferer)level.getCapability(ElementalCraftCapabilities.ElementTransferer.BLOCK, pos, (Object)side);
        if (transferer instanceof ElementPipeTransferer && (upgrade = (elementPipeTransferer = (ElementPipeTransferer)transferer).getUpgrade(side)) != null && !upgrade.canTransfer(type, connection)) {
            transferer = null;
        }
        if ((storage = (IElementStorage)level.getCapability(ElementalCraftCapabilities.ElementStorage.BLOCK, pos, (Object)side)) != null && !storage.canPipeInsert(type, side)) {
            storage = null;
        }
        return new Node(pos, transferer, storage);
    }

    public static List<BlockPos> getDefaultPos(BlockPos pos, Direction face, ConnectionType connection) {
        if (connection == ConnectionType.CONNECT || connection == ConnectionType.INSERT) {
            return List.of(pos.relative(face));
        }
        return Collections.emptyList();
    }

    @Override
    public int getRemainingTransferAmount() {
        if (!this.initialized) {
            return 0;
        }
        return this.maxTransferAmount - this.transferedAmount;
    }

    @Override
    public void onTransfer(@Nonnull ElementType type, int amount, @Nullable IElementTransferPathNode prev, @Nullable IElementTransferPathNode next) {
        this.getInvolvedUpgrades(type, prev, next).forEach(upgrade -> upgrade.onTransfer(type, amount, prev, next));
        this.transferedAmount += amount;
    }

    private List<PipeUpgrade> getInvolvedUpgrades(@Nonnull ElementType type, @Nullable IElementTransferPathNode prev, @Nullable IElementTransferPathNode next) {
        ArrayList list = new ArrayList(this.connections.size());
        this.connections.forEach((side, connection) -> {
            PipeUpgrade upgrade = this.getUpgrade((Direction)side);
            if (upgrade != null && (ElementPipeTransferer.isUpgradeConnectedTo(upgrade, prev, type, connection) || ElementPipeTransferer.isUpgradeConnectedTo(upgrade, next, type, connection))) {
                list.add(upgrade);
            }
        });
        return List.copyOf(list);
    }

    private static boolean isUpgradeConnectedTo(PipeUpgrade upgrade, @Nullable IElementTransferPathNode to, @NotNull ElementType type, ConnectionType connection) {
        if (to == null) {
            return false;
        }
        return upgrade.getConnections(type, connection).contains(to.getPos());
    }

    @Override
    public boolean isValid() {
        return this.initialized && this.transferedAmount < this.maxTransferAmount && !this.pipe.isRemoved();
    }

    void setConnection(Direction face, ConnectionType type) {
        this.connections.put(face, type);
    }

    public Map<Direction, PipeUpgrade> getUpgrades() {
        return Map.copyOf(this.upgrades);
    }

    public PipeUpgrade getUpgrade(Direction face) {
        return this.upgrades.get(face);
    }

    void setUpgrade(Direction face, PipeUpgrade upgrade) {
        if (upgrade != null) {
            this.upgrades.put(face, upgrade);
        }
    }

    public void removeUpgrade(Direction side) {
        this.upgrades.remove(side);
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        for (Direction face : Direction.values()) {
            this.setConnection(face, ConnectionType.byName(compound.getString(face.getSerializedName())));
            this.setUpgrade(face, PipeUpgradeHelper.load(this.pipe, face, compound.getCompound(face.getSerializedName() + "_upgrade"), provider));
        }
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        this.connections.forEach((k, v) -> compound.putString(k.getSerializedName(), v.getName()));
        this.upgrades.forEach((k, v) -> compound.put(k.getSerializedName() + "_upgrade", (Tag)v.save(provider)));
        return compound;
    }

    void copyTo(ElementPipeTransferer transferer) {
        for (Direction face : Direction.values()) {
            transferer.setConnection(face, this.getConnection(face));
            transferer.setUpgrade(face, this.getUpgrade(face));
        }
        transferer.transferedAmount = this.transferedAmount;
    }

    public record Node(BlockPos pos, IElementTransferer transferer, IElementStorage storage) implements IElementTransferPathNode
    {
        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public IElementTransferer getTransferer() {
            return this.transferer;
        }

        @Override
        public IElementStorage getStorage() {
            return this.storage;
        }

        @Override
        public int getWeight(@NotNull ElementType type, @Nullable IElementTransferPathNode prev, @Nullable IElementTransferPathNode next) {
            IElementTransferer iElementTransferer = this.transferer;
            if (!(iElementTransferer instanceof ElementPipeTransferer)) {
                return 1;
            }
            ElementPipeTransferer pipeTransferer = (ElementPipeTransferer)iElementTransferer;
            return 1 + pipeTransferer.getInvolvedUpgrades(type, prev, next).stream().mapToInt(PipeUpgrade::getWeight).sum();
        }
    }
}

