/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.pipe.ConnectionType;
import sirttas.elementalcraft.block.pipe.ElementPipeBlock;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgrade;
import sirttas.elementalcraft.block.pipe.upgrade.renderer.IPipeUpgradeRenderer;
import sirttas.elementalcraft.block.pipe.upgrade.renderer.PipeUpgradeRenderers;
import sirttas.elementalcraft.client.model.ECModelHelper;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class ElementPipeRenderer
implements BlockEntityRenderer<ElementPipeBlockEntity> {
    public static final ModelResourceLocation SIDE_LOCATION = ECModelHelper.standalone("block/elementpipe_side");
    public static final ModelResourceLocation EXTRACT_LOCATION = ECModelHelper.standalone("block/elementpipe_extract");
    private static final AABB BOX = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private BakedModel sideModel;
    private BakedModel extractModel;

    public void render(ElementPipeBlockEntity te, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int light, int overlay) {
        boolean showCover;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        Level level = Objects.requireNonNull(te.getLevel());
        BlockState coverState = te.getCoverState();
        boolean bl = showCover = !coverState.isAir();
        if (this.sideModel == null || this.extractModel == null) {
            ModelManager modelManager = minecraft.getModelManager();
            this.sideModel = modelManager.getModel(SIDE_LOCATION);
            this.extractModel = modelManager.getModel(EXTRACT_LOCATION);
        }
        if (showCover && ElementPipeBlock.showCover(te.getBlockState(), (Player)player)) {
            ECRendererHelper.renderBatched(coverState, poseStack, buffer, te.getLevel(), te.getBlockPos());
        } else {
            this.renderPipes(te, partialTicks, poseStack, buffer, light, overlay);
            if (showCover) {
                ECRendererHelper.renderBlock((BlockState)te.getBlockState().setValue(ElementPipeBlock.COVER, (Comparable)((Object)ElementPipeBlock.CoverType.NONE)), poseStack, buffer, light, overlay, ECRendererHelper.getModelData(level, te.getBlockPos()));
                LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer.getBuffer(RenderType.lines()), (AABB)BOX, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    private void renderPipes(ElementPipeBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.5, 0.5);
        Stream.of(Direction.values()).forEach(d -> this.renderSide(te, partialTicks, (Direction)d, matrixStack, buffer, light, overlay));
        matrixStack.popPose();
    }

    private void renderSide(ElementPipeBlockEntity te, float partialTicks, Direction side, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        ConnectionType connection = te.getConnection(side);
        PipeUpgrade upgrade = te.getUpgrade(side);
        RenderShape renderShape = upgrade == null ? RenderShape.INVISIBLE : upgrade.getRenderShape();
        matrixStack.pushPose();
        matrixStack.mulPose(side.getRotation());
        matrixStack.translate(-0.5, -0.5, -0.5);
        if (upgrade != null) {
            IPipeUpgradeRenderer<PipeUpgrade> upgradeRenderer;
            if (renderShape == RenderShape.MODEL) {
                ECRendererHelper.renderModel(upgrade.getType().getModel(), matrixStack, buffer, te, light, overlay);
            }
            if (renderShape != RenderShape.INVISIBLE && (upgradeRenderer = PipeUpgradeRenderers.get(upgrade)) != null) {
                upgradeRenderer.render(upgrade, te, partialTicks, matrixStack, buffer, light, overlay);
            }
        }
        if (connection.isConnected()) {
            if (upgrade == null || !upgrade.replaceSection()) {
                ECRendererHelper.renderModel(this.sideModel, matrixStack, buffer, te, light, overlay);
            }
            if (!(connection != ConnectionType.EXTRACT || upgrade != null && upgrade.replaceExtraction())) {
                ECRendererHelper.renderModel(this.extractModel, matrixStack, buffer, te, light, overlay);
            }
        }
        matrixStack.popPose();
    }
}

