/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.transfer.IElementTransferer;
import sirttas.elementalcraft.api.element.transfer.path.IElementTransferPath;
import sirttas.elementalcraft.api.element.transfer.path.SimpleElementTransferPathfinder;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.pipe.ConnectionType;
import sirttas.elementalcraft.block.pipe.ElementPipeBlock;
import sirttas.elementalcraft.block.pipe.ElementPipeShapes;
import sirttas.elementalcraft.block.pipe.ElementPipeTransferer;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgrade;

public class ElementPipeBlockEntity
extends AbstractECBlockEntity {
    private final ElementPipeTransferer transferer = new ElementPipeTransferer(this);
    private BlockState coverState = Blocks.AIR.defaultBlockState();

    public ElementPipeBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.PIPE, pos, state);
    }

    public ConnectionType getConnection(Direction face) {
        return this.transferer.getConnection(face);
    }

    public void copyTo(ElementPipeBlockEntity newBlockEntity) {
        this.transferer.copyTo(newBlockEntity.transferer);
        newBlockEntity.coverState = this.coverState;
    }

    public VoxelShape getShape(@Nullable Direction face) {
        if (face == null) {
            return ElementPipeShapes.BASE_SHAPE;
        }
        ConnectionType connexion = this.transferer.getConnection(face);
        VoxelShape shape = Shapes.empty();
        PipeUpgrade upgrade = this.transferer.getUpgrade(face);
        if (upgrade != null) {
            shape = upgrade.getShape();
        }
        if (connexion.isConnected()) {
            if (upgrade == null || !upgrade.replaceSection()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)ElementPipeShapes.SECTION_SHAPES.get(face));
            }
            if (!(connexion != ConnectionType.EXTRACT || upgrade != null && upgrade.replaceExtraction())) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)ElementPipeShapes.EXTRACTION_SHAPES.get(face));
            }
        }
        return shape;
    }

    public VoxelShape getShape() {
        VoxelShape shape = ElementPipeShapes.BASE_SHAPE;
        for (Direction face : Direction.values()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)this.getShape(face));
        }
        return shape;
    }

    private void setConnection(Direction face, ConnectionType type) {
        if (this.transferer.getConnection(face) == type) {
            return;
        }
        this.transferer.setConnection(face, type);
        this.setChanged();
        if (this.level != null) {
            this.getBlockState().updateNeighbourShapes((LevelAccessor)this.level, this.getBlockPos(), 3);
        }
    }

    private void refresh(Direction face) {
        if (this.level == null) {
            return;
        }
        ConnectionType connection = this.lookupConnection(face);
        this.setConnection(face, connection);
        PipeUpgrade upgrade = this.transferer.getUpgrade(face);
        if (upgrade != null && !upgrade.canPlace(connection)) {
            this.removeUpgrade(face);
        }
    }

    private ConnectionType lookupConnection(Direction face) {
        BlockPos adjacent = this.getBlockPos().relative(face);
        ConnectionType connection = this.getConnection(face);
        Direction opposite = face.getOpposite();
        IElementTransferer t = (IElementTransferer)this.level.getCapability(ElementalCraftCapabilities.ElementTransferer.BLOCK, adjacent, (Object)opposite);
        if (t != null) {
            if (t.canConnectTo(this.getBlockPos())) {
                return ElementPipeBlockEntity.connectionOrDefault(connection, ConnectionType.CONNECT);
            }
            return ConnectionType.NONE;
        }
        IElementStorage storage = (IElementStorage)this.level.getCapability(ElementalCraftCapabilities.ElementStorage.BLOCK, adjacent, (Object)opposite);
        if (storage != null) {
            if (this.canInsertInStorage(storage, opposite)) {
                return ElementPipeBlockEntity.connectionOrDefault(connection, ConnectionType.INSERT);
            }
            if (this.canExtractFromStorage(storage, opposite)) {
                return ElementPipeBlockEntity.connectionOrDefault(connection, ConnectionType.EXTRACT);
            }
            return ConnectionType.NONE;
        }
        return ConnectionType.NONE;
    }

    private static ConnectionType connectionOrDefault(ConnectionType connection, ConnectionType defaultConnection) {
        return connection != ConnectionType.NONE ? connection : defaultConnection;
    }

    void refresh() {
        for (Direction face : Direction.values()) {
            this.refresh(face);
        }
    }

    private void transferElement(IElementStorage sender, Direction side, ElementType type) {
        BlockPos pos = this.getBlockPos();
        if (type != ElementType.NONE && this.level != null) {
            PipeUpgrade upgrade = this.transferer.getUpgrade(side);
            if (upgrade != null && !upgrade.canTransfer(type, ConnectionType.EXTRACT) || !this.canExtractFromStorage(sender, side.getOpposite())) {
                return;
            }
            SimpleElementTransferPathfinder pathfinder = new SimpleElementTransferPathfinder(this.level);
            List<IElementTransferPath> paths = pathfinder.findPaths(type, new ElementPipeTransferer.Node(pos.relative(side), null, sender), new ElementPipeTransferer.Node(pos, this.transferer, null));
            for (IElementTransferPath path : paths) {
                if (!this.transferer.isValid()) {
                    return;
                }
                if (!path.isValid()) continue;
                if (upgrade != null) {
                    path = upgrade.alterPath(path);
                }
                path.transfer();
            }
        }
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, ElementPipeBlockEntity pipe) {
        pipe.refresh();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ElementPipeBlockEntity pipe) {
        pipe.transferer.init();
        ElementPipeBlockEntity.commonTick(level, pos, state, pipe);
        if (!pipe.transferer.isValid()) {
            return;
        }
        ProfilerFiller profiler = level.getProfiler();
        profiler.push("elementalcraft:element_pipe_element_transfer");
        pipe.transferer.getConnections().entrySet().stream().filter(entry -> entry.getValue() == ConnectionType.EXTRACT).sorted(Comparator.comparing(entry -> pipe.transferer.getUpgradeWeight((Direction)entry.getKey()))).map(Map.Entry::getKey).forEach(side -> {
            if (!pipe.transferer.isValid()) {
                return;
            }
            BlockPos adjacent = pos.relative(side);
            IElementStorage sender = (IElementStorage)level.getCapability(ElementalCraftCapabilities.ElementStorage.BLOCK, adjacent, (Object)side.getOpposite());
            if (sender instanceof IElementTypeProvider) {
                IElementTypeProvider provider = (IElementTypeProvider)((Object)sender);
                pipe.transferElement(sender, (Direction)side, provider.getElementType());
            }
        });
        profiler.pop();
    }

    public IElementTransferer getTransferer() {
        return this.transferer;
    }

    public Map<Direction, PipeUpgrade> getUpgrades() {
        return this.transferer.getUpgrades();
    }

    public PipeUpgrade getUpgrade(Direction face) {
        return this.transferer.getUpgrade(face);
    }

    public void setUpgrade(Direction face, PipeUpgrade upgrade) {
        this.transferer.setUpgrade(face, Objects.requireNonNull(upgrade));
        upgrade.onAdded();
    }

    private void removeUpgrade(Direction side) {
        this.removeUpgrade(null, side);
    }

    private void removeUpgrade(@Nullable Player player, Direction side) {
        PipeUpgrade upgrade = this.getUpgrade(side);
        if (upgrade == null) {
            return;
        }
        upgrade.dropAll(player);
        this.transferer.removeUpgrade(side);
        upgrade.onRemoved();
    }

    void removeAllUpgrades() {
        for (Direction side : Direction.values()) {
            this.removeUpgrade(side);
        }
    }

    public ItemInteractionResult activatePipe(@Nullable Player player, Direction face) {
        if (this.level == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        PipeUpgrade upgrade = this.getUpgrade(face);
        if (upgrade != null) {
            this.removeUpgrade(player, face);
            return ItemInteractionResult.SUCCESS;
        }
        Direction opposite = face.getOpposite();
        BlockPos adjacent = this.getBlockPos().relative(face);
        ConnectionType connection = this.getConnection(face);
        switch (connection) {
            case INSERT: {
                IElementStorage storage = (IElementStorage)this.level.getCapability(ElementalCraftCapabilities.ElementStorage.BLOCK, adjacent, (Object)opposite);
                if (this.canExtractFromStorage(storage, opposite)) {
                    this.setConnection(face, ConnectionType.EXTRACT);
                } else {
                    this.setConnection(face, ConnectionType.DISCONNECT);
                }
                return ItemInteractionResult.SUCCESS;
            }
            case EXTRACT: 
            case CONNECT: {
                this.setConnection(face, ConnectionType.DISCONNECT);
                BlockEntity blockEntity = this.level.getBlockEntity(adjacent);
                if (blockEntity instanceof ElementPipeBlockEntity) {
                    ElementPipeBlockEntity pipe = (ElementPipeBlockEntity)blockEntity;
                    pipe.setConnection(face.getOpposite(), ConnectionType.DISCONNECT);
                }
                return ItemInteractionResult.SUCCESS;
            }
            case DISCONNECT: {
                IElementStorage storage = (IElementStorage)this.level.getCapability(ElementalCraftCapabilities.ElementStorage.BLOCK, adjacent, (Object)opposite);
                if (this.canInsertInStorage(storage, opposite)) {
                    this.setConnection(face, ConnectionType.INSERT);
                } else if (this.canExtractFromStorage(storage, opposite)) {
                    this.setConnection(face, ConnectionType.EXTRACT);
                } else {
                    BlockEntity blockEntity = this.level.getBlockEntity(adjacent);
                    if (blockEntity instanceof ElementPipeBlockEntity) {
                        ElementPipeBlockEntity pipe = (ElementPipeBlockEntity)blockEntity;
                        this.setConnection(face, ConnectionType.CONNECT);
                        pipe.setConnection(face.getOpposite(), ConnectionType.CONNECT);
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private boolean canInsertInStorage(@Nullable IElementStorage storage, Direction face) {
        if (storage == null) {
            return false;
        }
        return ElementType.ALL_VALID.stream().anyMatch(type -> storage.canPipeInsert((ElementType)type, face));
    }

    private boolean canExtractFromStorage(IElementStorage storage, Direction face) {
        if (storage == null) {
            return false;
        }
        return ElementType.ALL_VALID.stream().anyMatch(type -> storage.canPipeExtract((ElementType)type, face));
    }

    public Component getConnectionMessage(Direction face) {
        return this.getConnection(face).getDisplayName();
    }

    public BlockState getCoverState() {
        return this.coverState;
    }

    public boolean isCovered() {
        return !this.coverState.isAir();
    }

    public int getMaxTransferAmount() {
        return this.transferer.maxTransferAmount;
    }

    public ItemInteractionResult setCover(Player player, InteractionHand hand) {
        if (this.level == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState state = blockItem.getBlock().defaultBlockState();
        if (state == this.coverState) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!this.coverState.isAir()) {
            Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)new ItemStack((ItemLike)this.coverState.getBlock()));
        }
        this.coverState = state;
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.level.getBlockState(this.worldPosition).setValue(ElementPipeBlock.COVER, (Comparable)((Object)ElementPipeBlock.CoverType.COVERED)));
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
            if (stack.isEmpty()) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (compound.contains("transferer")) {
            this.transferer.deserializeNBT(provider, compound.getCompound("transferer"));
        }
        this.coverState = compound.contains("cover") ? NbtUtils.readBlockState((HolderGetter)provider.lookupOrThrow(Registries.BLOCK), (CompoundTag)compound.getCompound("cover")) : Blocks.AIR.defaultBlockState();
    }

    public void saveAdditional(@NotNull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("transferer", (Tag)this.transferer.serializeNBT(provider));
        if (!this.coverState.isAir()) {
            compound.put("cover", (Tag)NbtUtils.writeBlockState((BlockState)this.coverState));
        } else if (compound.contains("cover")) {
            compound.remove("cover");
        }
    }
}

