/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.AbstractECEntityBlock;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.ElementPipeShapes;
import sirttas.elementalcraft.block.shape.ShapeHelper;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.item.pipe.IPipeInteractingItem;
import sirttas.elementalcraft.tag.ECTags;

public class ElementPipeBlock
extends AbstractECEntityBlock {
    public static final String NAME = "elementpipe";
    public static final String NAME_RUDIMENTARY = "elementpipe_rudimentary";
    public static final String NAME_IMPROVED = "elementpipe_improved";
    public static final String NAME_CREATIVE = "elementpipe_creative";
    public static final MapCodec<ElementPipeBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PipeType.CODEC.fieldOf("pipe_type").forGetter(p -> p.type), (App)ElementPipeBlock.propertiesCodec()).apply((Applicative)instance, ElementPipeBlock::new));
    public static final EnumProperty<CoverType> COVER = EnumProperty.create((String)"cover", CoverType.class);
    private final PipeType type;

    public ElementPipeBlock(PipeType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(COVER, (Comparable)((Object)CoverType.NONE)));
        this.type = type;
    }

    @NotNull
    protected MapCodec<ElementPipeBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> container) {
        container.add(new Property[]{COVER});
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ElementPipeBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return ElementPipeBlock.createECTicker(level, type, ECBlockEntityTypes.PIPE, level.isClientSide ? ElementPipeBlockEntity::commonTick : ElementPipeBlockEntity::serverTick);
    }

    public void onPlace(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ElementPipeBlockEntity) {
            ElementPipeBlockEntity pipe = (ElementPipeBlockEntity)blockEntity;
            pipe.refresh();
        }
    }

    public static boolean showCover(BlockState state, Player player) {
        return ElementPipeBlock.isCovered(state) && (player == null || EntityHelper.handStream((LivingEntity)player).noneMatch(stack -> !stack.isEmpty() && stack.is(ECTags.Items.PIPE_COVER_HIDING)));
    }

    private static boolean isCovered(BlockState state) {
        return state.getValue(COVER) == CoverType.COVERED;
    }

    private VoxelShape getCurrentShape(BlockState state, ElementPipeBlockEntity entity, Player player) {
        if (ElementPipeBlock.showCover(state, (Player)(entity != null ? player : null))) {
            return Shapes.block();
        }
        if (entity == null) {
            return Shapes.empty();
        }
        return entity.getShape();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        Player player = this.getPlayer(context);
        ElementPipeBlockEntity blockEntity = ElementPipeBlock.getBlockEntity(blockGetter, pos);
        if (blockGetter instanceof Level) {
            Level level = (Level)blockGetter;
            if (level.isClientSide) {
                voxelShape = (VoxelShape)this.getShapeAndFace(state, pos, blockEntity, Minecraft.getInstance().hitResult, player).getFirst();
                return voxelShape;
            }
        }
        voxelShape = this.getCurrentShape(state, blockEntity, player);
        return voxelShape;
    }

    private Player getPlayer(CollisionContext context) {
        EntityCollisionContext entityContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityContext = (EntityCollisionContext)context).getEntity()) instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    public Pair<VoxelShape, Direction> getShapeAndFace(BlockState state, BlockPos pos, ElementPipeBlockEntity pipe, HitResult result, Player player) {
        BlockHitResult blockHitResult;
        if (!ElementPipeBlock.showCover(state, player) && result instanceof BlockHitResult && (blockHitResult = (BlockHitResult)result).getType() == HitResult.Type.BLOCK && blockHitResult.getBlockPos().equals((Object)pos)) {
            Vec3 hit = blockHitResult.getLocation();
            for (Direction face : Direction.values()) {
                VoxelShape shape = pipe.getShape(face);
                if (!ShapeHelper.vectorCollideWithShape(shape, pos, hit)) continue;
                return Pair.of((Object)shape, (Object)face);
            }
            if (ShapeHelper.vectorCollideWithShape(ElementPipeShapes.BASE_SHAPE, pos, hit)) {
                return Pair.of((Object)ElementPipeShapes.BASE_SHAPE, (Object)blockHitResult.getDirection());
            }
            if (ShapeHelper.vectorCollideWithShape(ElementPipeShapes.FRAME_SHAPE, pos, hit)) {
                return Pair.of((Object)ElementPipeShapes.FRAME_SHAPE, null);
            }
        }
        return Pair.of((Object)this.getCurrentShape(state, pipe, player), null);
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getCurrentShape(state, ElementPipeBlock.getBlockEntity(level, pos), null);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        ElementPipeBlockEntity pipe = (ElementPipeBlockEntity)level.getBlockEntity(pos);
        if (pipe != null) {
            ItemInteractionResult value;
            Pair<VoxelShape, Direction> pair = this.getShapeAndFace(state, pos, ElementPipeBlock.getBlockEntity((BlockGetter)level, pos), (HitResult)hit, player);
            VoxelShape shape = (VoxelShape)pair.getFirst();
            if (shape == ElementPipeShapes.FRAME_SHAPE || state.getValue(COVER) == CoverType.FRAME) {
                return pipe.setCover(player, hand);
            }
            if (shape == ElementPipeShapes.BASE_SHAPE && (value = this.upgrade(state, level, pos, player, hand)).consumesAction()) {
                return value;
            }
            Direction face = (Direction)pair.getSecond();
            ItemInteractionResult value2 = this.onShapeActivated(face, pipe, player, hand, hit);
            if (!value2.consumesAction()) {
                player.displayClientMessage(pipe.getConnectionMessage(face), true);
                level.updateNeighborsAt(pos, (Block)this);
            }
            return value2;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private ItemInteractionResult upgrade(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand) {
        ElementPipeBlock block;
        ItemStack stack;
        block8: {
            block7: {
                BlockItem item;
                Item item2;
                if (!state.is((Block)this)) {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                stack = player.getItemInHand(hand);
                if (stack.isEmpty() || !((item2 = stack.getItem()) instanceof BlockItem) || !((item2 = (item = (BlockItem)item2).getBlock()) instanceof ElementPipeBlock)) break block7;
                block = (ElementPipeBlock)item2;
                if (block.type.getTiers() > this.type.getTiers()) break block8;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ElementPipeBlockEntity oldBlockEntity = ElementPipeBlock.getBlockEntity((BlockGetter)level, pos);
        level.setBlockAndUpdate(pos, (BlockState)block.defaultBlockState().setValue(COVER, (Comparable)((Object)((CoverType)((Object)state.getValue(COVER))))));
        ElementPipeBlockEntity newBlockEntity = ElementPipeBlock.getBlockEntity((BlockGetter)level, pos);
        if (oldBlockEntity != null && newBlockEntity != null) {
            oldBlockEntity.copyTo(newBlockEntity);
            newBlockEntity.refresh();
        }
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
            EntityHelper.dropAtFeet(level, (Entity)player, new ItemStack((ItemLike)state.getBlock()));
        }
        level.levelEvent(player, 2001, pos, Block.getId((BlockState)state));
        for (Direction face : Direction.values()) {
            BlockPos p = pos.relative(face);
            this.upgrade(level.getBlockState(p), level, p, player, hand);
        }
        return ItemInteractionResult.SUCCESS;
    }

    private ItemInteractionResult onShapeActivated(Direction face, ElementPipeBlockEntity pipe, Player player, InteractionHand hand, BlockHitResult hit) {
        if (face != null) {
            Item item;
            ItemStack stack = player.getItemInHand(hand);
            if (!stack.isEmpty() && (item = stack.getItem()) instanceof IPipeInteractingItem) {
                IPipeInteractingItem item2 = (IPipeInteractingItem)item;
                return item2.useOnPipe(pipe, new UseOnContext(player, hand, new BlockHitResult(hit.getLocation(), face, hit.getBlockPos(), hit.isInside())));
            }
            return pipe.activatePipe(player, face);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public void onRemove(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        Block newBlock = newState.getBlock();
        if (newBlock instanceof ElementPipeBlock || state.getBlock() == newBlock) {
            return;
        }
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof ElementPipeBlockEntity) {
            ElementPipeBlockEntity pipe = (ElementPipeBlockEntity)te;
            if (ElementPipeBlock.isCovered(state)) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)pipe.getCoverState().getBlock()));
            }
            pipe.removeAllUpgrades();
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    private static ElementPipeBlockEntity getBlockEntity(BlockGetter level, BlockPos pos) {
        return BlockEntityHelper.getBlockEntityAs(level, pos, ElementPipeBlockEntity.class).orElse(null);
    }

    public PipeType getType() {
        return this.type;
    }

    public static enum CoverType implements StringRepresentable
    {
        NONE("none"),
        FRAME("frame"),
        COVERED("covered");

        public static final Codec<CoverType> CODEC;
        private final String name;

        private CoverType(String name) {
            this.name = name;
        }

        @Nonnull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(CoverType::values);
        }
    }

    public static enum PipeType implements StringRepresentable
    {
        RUDIMENTARY("rudimentary", 0),
        STANDARD("standard", 1),
        IMPROVED("improved", 2),
        CREATIVE("creative", 3);

        private static final Codec<PipeType> CODEC;
        private final int tiers;
        private final String name;

        private PipeType(String name, int tiers) {
            this.name = name;
            this.tiers = tiers;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public int getTiers() {
            return this.tiers;
        }

        static {
            CODEC = StringRepresentable.fromEnum(PipeType::values);
        }
    }
}

