/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;

public enum ConnectionType {
    NONE("none", false),
    CONNECT("connect", true),
    INSERT("insert", true),
    EXTRACT("extract", true),
    DISCONNECT("disconnect", false);

    private final String name;
    private final boolean connected;

    private ConnectionType(String name, boolean connected) {
        this.name = name;
        this.connected = connected;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getName() {
        return this.name;
    }

    public static ConnectionType byName(String name) {
        for (ConnectionType type : ConnectionType.values()) {
            if (!StringUtils.endsWithIgnoreCase((CharSequence)type.getName(), (CharSequence)name)) continue;
            return type;
        }
        return NONE;
    }

    public Component getDisplayName() {
        return Component.translatable((String)("message.elementalcraft.pipe." + this.name));
    }
}

