/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.io.purifier;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.instrument.io.purifier.PurifierBlock;
import sirttas.elementalcraft.block.instrument.io.purifier.PurifierBlockEntity;
import sirttas.elementalcraft.renderer.ECRendererHelper;

@OnlyIn(value=Dist.CLIENT)
public class PurifierRenderer
implements BlockEntityRenderer<PurifierBlockEntity> {
    public void render(PurifierBlockEntity te, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Container inv = te.getInventory();
        ItemStack stack = inv.getItem(0);
        ItemStack stack2 = inv.getItem(1);
        float tick = ECRendererHelper.getClientTicks(partialTicks);
        ECRendererHelper.renderRunes(matrixStack, buffer, te.getRuneHandler(), tick, light, overlay);
        if (!stack.isEmpty() || !stack2.isEmpty()) {
            matrixStack.translate(0.5, 0.5, 0.5);
            matrixStack.mulPose(ECRendererHelper.getRotation((Direction)te.getBlockState().getValue((Property)PurifierBlock.FACING)));
            if (!stack.isEmpty()) {
                matrixStack.pushPose();
                matrixStack.translate(0.0, -0.3125, -0.375);
                if (!(stack.getItem() instanceof BlockItem)) {
                    matrixStack.translate(0.0, 0.125, 0.0);
                    matrixStack.scale(0.5f, 0.5f, 0.5f);
                    matrixStack.mulPose(Axis.YP.rotationDegrees(tick));
                }
                ECRendererHelper.renderItem(stack, matrixStack, buffer, light, overlay);
                matrixStack.popPose();
            }
            if (!stack2.isEmpty()) {
                matrixStack.translate(0.0, 0.2875, 0.0);
                matrixStack.mulPose(Axis.YP.rotationDegrees(tick));
                ECRendererHelper.renderItem(stack2, matrixStack, buffer, light, overlay);
            }
        }
    }
}

