/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.io.purifier;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.instrument.io.AbstractIOInstrumentBlockEntity;
import sirttas.elementalcraft.block.instrument.io.purifier.PurifierContainer;
import sirttas.elementalcraft.recipe.instrument.io.SimpleIOInstrumentRecipeInput;
import sirttas.elementalcraft.recipe.instrument.io.purification.OrePurificationRecipe;

public class PurifierBlockEntity
extends AbstractIOInstrumentBlockEntity<SimpleIOInstrumentRecipeInput, OrePurificationRecipe> {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("purifier");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);
    private final PurifierContainer inventory = new PurifierContainer(this::setChanged);

    public PurifierBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.PURIFIER, PROPERTIES, pos, state);
    }

    @Override
    @Nonnull
    public IItemHandler getItemHandler(@Nullable Direction direction) {
        return new SidedInvWrapper((WorldlyContainer)this.inventory, direction);
    }

    @Override
    @NotNull
    protected SimpleIOInstrumentRecipeInput createRecipeInput() {
        return this.createSimpleIORecipeInput();
    }

    @Override
    @Nonnull
    @NotNull
    public Container getInventory() {
        return this.inventory;
    }
}

