/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.io.purifier;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.WaterLoggingHelper;
import sirttas.elementalcraft.block.container.ElementContainer;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.instrument.IInstrumentBlock;
import sirttas.elementalcraft.block.instrument.io.purifier.PurifierBlockEntity;
import sirttas.elementalcraft.container.ECContainerHelper;
import sirttas.elementalcraft.pureore.PureOreManager;

public class PurifierBlock
extends AbstractECContainerBlock
implements IInstrumentBlock {
    public static final String NAME = "purifier";
    public static final MapCodec<PurifierBlock> CODEC = PurifierBlock.simpleCodec(PurifierBlock::new);
    private static final VoxelShape OVEN_SLAB = Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape OVEN_SLAB_2 = Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape CONNECTION = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0);
    private static final VoxelShape PILLAT_1 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)10.0, (double)3.0);
    private static final VoxelShape PILLAT_2 = Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)3.0);
    private static final VoxelShape PILLAT_3 = Block.box((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)10.0, (double)15.0);
    private static final VoxelShape PILLAT_4 = Block.box((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)10.0, (double)15.0);
    private static final VoxelShape MAIN_SHAPE = Shapes.or((VoxelShape)OVEN_SLAB, (VoxelShape[])new VoxelShape[]{OVEN_SLAB_2, CONNECTION, PILLAT_1, PILLAT_2, PILLAT_3, PILLAT_4});
    private static final VoxelShape NORTH_EMPTY_SPACE = Block.box((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0);
    private static final VoxelShape NORTH_OVEN_BLOCK = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)10.0, (double)7.0);
    private static final VoxelShape NORTH_OVEN_BLOCK_2 = Block.box((double)6.0, (double)4.0, (double)7.0, (double)10.0, (double)8.0, (double)11.0);
    private static final VoxelShape NORTH_OVEN = Shapes.join((VoxelShape)Shapes.or((VoxelShape)NORTH_OVEN_BLOCK, (VoxelShape)NORTH_OVEN_BLOCK_2), (VoxelShape)NORTH_EMPTY_SPACE, (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape SOUTH_EMPTY_SPACE = Block.box((double)6.0, (double)4.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0);
    private static final VoxelShape SOUTH_OVEN_BLOCK = Block.box((double)4.0, (double)4.0, (double)9.0, (double)12.0, (double)10.0, (double)16.0);
    private static final VoxelShape SOUTH_OVEN_BLOCK_2 = Block.box((double)6.0, (double)4.0, (double)5.0, (double)10.0, (double)8.0, (double)9.0);
    private static final VoxelShape SOUTH_OVEN = Shapes.join((VoxelShape)Shapes.or((VoxelShape)SOUTH_OVEN_BLOCK, (VoxelShape)SOUTH_OVEN_BLOCK_2), (VoxelShape)SOUTH_EMPTY_SPACE, (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape WEST_EMPTY_SPACE = Block.box((double)0.0, (double)4.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0);
    private static final VoxelShape WEST_OVEN_BLOCK = Block.box((double)0.0, (double)4.0, (double)4.0, (double)7.0, (double)10.0, (double)12.0);
    private static final VoxelShape WEST_OVEN_BLOCK_2 = Block.box((double)7.0, (double)4.0, (double)6.0, (double)11.0, (double)8.0, (double)10.0);
    private static final VoxelShape WEST_OVEN = Shapes.join((VoxelShape)Shapes.or((VoxelShape)WEST_OVEN_BLOCK, (VoxelShape)WEST_OVEN_BLOCK_2), (VoxelShape)WEST_EMPTY_SPACE, (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape EAST_EMPTY_SPACE = Block.box((double)12.0, (double)4.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0);
    private static final VoxelShape EAST_OVEN_BLOCK = Block.box((double)9.0, (double)4.0, (double)4.0, (double)16.0, (double)10.0, (double)12.0);
    private static final VoxelShape EAST_OVEN_BLOCK_2 = Block.box((double)5.0, (double)4.0, (double)6.0, (double)9.0, (double)8.0, (double)10.0);
    private static final VoxelShape EAST_OVEN = Shapes.join((VoxelShape)Shapes.or((VoxelShape)EAST_OVEN_BLOCK, (VoxelShape)EAST_OVEN_BLOCK_2), (VoxelShape)EAST_EMPTY_SPACE, (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)MAIN_SHAPE, (VoxelShape)NORTH_OVEN);
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)MAIN_SHAPE, (VoxelShape)SOUTH_OVEN);
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)MAIN_SHAPE, (VoxelShape)EAST_OVEN);
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)MAIN_SHAPE, (VoxelShape)WEST_OVEN);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public PurifierBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<PurifierBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new PurifierBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return this.createInstrumentTicker(level, type, ECBlockEntityTypes.PURIFIER);
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, Level level, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        PurifierBlockEntity purifier = (PurifierBlockEntity)level.getBlockEntity(pos);
        IItemHandler inv = ECContainerHelper.getItemHandlerAt((BlockGetter)level, pos, null);
        ItemStack heldItem = player.getItemInHand(hand);
        if (purifier != null && hand == InteractionHand.MAIN_HAND) {
            if (!purifier.getInventory().getItem(1).isEmpty()) {
                return this.onSlotActivated(inv, player, ItemStack.EMPTY, 1);
            }
            if (heldItem.isEmpty() || PureOreManager.getInstance().isValidOre(heldItem)) {
                return this.onSlotActivated(inv, player, heldItem, 0);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> MAIN_SHAPE;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(WaterLoggingHelper.isPlacedInWater(context)));
    }

    @Nonnull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Nonnull
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING});
    }

    public boolean canSurvive(@NotNull BlockState state, @Nonnull LevelReader level, BlockPos pos) {
        return ElementContainer.isValidContainer(state, level, pos.below());
    }

    @Nonnull
    public FluidState getFluidState(@Nonnull BlockState state) {
        return WaterLoggingHelper.isWaterlogged(state) ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        WaterLoggingHelper.scheduleWaterTick(state, level, pos);
        return !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, pos, facingPos);
    }
}

