/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.io.mill;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sirttas.elementalcraft.block.airmill.AirMill;
import sirttas.elementalcraft.block.entity.crafting.AbstractECCraftingBlockEntity;
import sirttas.elementalcraft.block.instrument.AbstractInstrumentBlockEntity;
import sirttas.elementalcraft.block.instrument.io.mill.AbstractMillBlock;
import sirttas.elementalcraft.block.instrument.io.mill.AbstractMillBlockEntity;
import sirttas.elementalcraft.client.model.ECModelHelper;
import sirttas.elementalcraft.renderer.ECRendererHelper;

@OnlyIn(value=Dist.CLIENT)
public class MillRenderer<T extends AbstractMillBlockEntity<?>>
implements BlockEntityRenderer<T> {
    public static final ModelResourceLocation WATER_MILL_GRINDSTONE_SHAFT_LOCATION = ECModelHelper.standalone("block/water_mill_grindstone_shaft");
    public static final ModelResourceLocation AIR_MILL_GRINDSTONE_SHAFT_LOCATION = ECModelHelper.standalone("block/air_mill_grindstone_shaft");
    public static final ModelResourceLocation WATER_MILL_WOOD_SAW_SHAFT_LOCATION = ECModelHelper.standalone("block/water_mill_wood_saw_shaft");
    public static final ModelResourceLocation AIR_MILL_WOOD_SAW_SHAFT_LOCATION = ECModelHelper.standalone("block/air_mill_wood_saw_shaft");
    private final ModelResourceLocation modelLocation;
    private BakedModel model;

    public MillRenderer(ModelResourceLocation modelLocation) {
        this.modelLocation = modelLocation;
    }

    public void render(@Nonnull T te, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        AirMill airMill;
        if (this.model == null && this.modelLocation != null) {
            this.model = Minecraft.getInstance().getModelManager().getModel(this.modelLocation);
        }
        Container inv = ((AbstractMillBlockEntity)te).getInventory();
        ItemStack stack = inv.getItem(0);
        ItemStack stack2 = inv.getItem(1);
        float tick = ECRendererHelper.getClientTicks(partialTicks);
        ECRendererHelper.renderRunes(matrixStack, buffer, ((AbstractECCraftingBlockEntity)te).getRuneHandler(), tick, light, overlay);
        if (!(te instanceof AirMill) || !(airMill = (AirMill)te).isBroken()) {
            matrixStack.pushPose();
            matrixStack.translate(0.0, 0.25, 0.0);
            if (((AbstractInstrumentBlockEntity)te).isRunning()) {
                matrixStack.translate(0.5, 0.0, 0.5);
                matrixStack.mulPose(Axis.YP.rotationDegrees(-5.0f * tick));
                matrixStack.translate(-0.5, 0.0, -0.5);
            }
            ECRendererHelper.renderModel(this.model, matrixStack, buffer, te, light, overlay);
            matrixStack.popPose();
        }
        if (!stack.isEmpty() || !stack2.isEmpty()) {
            matrixStack.translate(0.5, 0.3, 0.5);
            matrixStack.mulPose(ECRendererHelper.getRotation((Direction)te.getBlockState().getValue((Property)AbstractMillBlock.FACING)));
            matrixStack.translate(0.0, 0.0, -0.375);
            if (!stack.isEmpty()) {
                matrixStack.pushPose();
                matrixStack.mulPose(Axis.YP.rotationDegrees(tick));
                ECRendererHelper.renderItem(stack, matrixStack, buffer, light, overlay);
                matrixStack.popPose();
            }
            if (!stack2.isEmpty()) {
                matrixStack.translate(0.0, 0.0, 0.75);
                matrixStack.mulPose(Axis.YP.rotationDegrees(tick));
                ECRendererHelper.renderItem(stack2, matrixStack, buffer, light, overlay);
            }
        }
    }
}

