/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.io.mill;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.instrument.io.AbstractIOInstrumentBlockEntity;
import sirttas.elementalcraft.container.IOContainer;
import sirttas.elementalcraft.recipe.instrument.io.IOInstrumentRecipe;
import sirttas.elementalcraft.recipe.instrument.io.SimpleIOInstrumentRecipeInput;

public abstract class AbstractMillBlockEntity<R extends IOInstrumentRecipe<SimpleIOInstrumentRecipeInput>>
extends AbstractIOInstrumentBlockEntity<SimpleIOInstrumentRecipeInput, R> {
    private final ElementType elementType;
    private final Container inventory = new IOContainer(this::setChanged);

    protected AbstractMillBlockEntity(Supplier<? extends BlockEntityType<?>> blockEntityType, Holder<IConfigurableBlockEntityProperties> properties, ElementType elementType, BlockPos pos, BlockState state) {
        super(blockEntityType, properties, pos, state);
        this.elementType = elementType;
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.inventory;
    }

    @Override
    protected ElementType getRecipeElementType() {
        return this.recipe == null ? ElementType.NONE : this.elementType;
    }

    @Override
    public boolean isRecipeAvailable() {
        return this.getContainerElementType() == this.elementType && super.isRecipeAvailable();
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    @NotNull
    protected SimpleIOInstrumentRecipeInput createRecipeInput() {
        return this.createSimpleIORecipeInput();
    }
}

