/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.io.mill;

import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.WaterLoggingHelper;
import sirttas.elementalcraft.block.container.ElementContainer;
import sirttas.elementalcraft.block.instrument.IInstrumentBlock;
import sirttas.elementalcraft.block.instrument.io.mill.AbstractMillBlockEntity;
import sirttas.elementalcraft.block.shape.ShapeHelper;
import sirttas.elementalcraft.container.ECContainerHelper;

public abstract class AbstractMillBlock
extends AbstractECContainerBlock
implements IInstrumentBlock {
    private static final VoxelShape OVEN_SLAB = Block.box((double)3.0, (double)2.0, (double)1.0, (double)13.0, (double)4.0, (double)15.0);
    private static final VoxelShape OVEN_SLAB_2 = Block.box((double)3.0, (double)10.0, (double)1.0, (double)13.0, (double)12.0, (double)15.0);
    private static final VoxelShape OVEN_CONNECTION = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0);
    private static final VoxelShape OVEN_PILLAR_1 = Block.box((double)4.0, (double)4.0, (double)2.0, (double)6.0, (double)10.0, (double)4.0);
    private static final VoxelShape OVEN_PILLAR_2 = Block.box((double)10.0, (double)4.0, (double)2.0, (double)12.0, (double)10.0, (double)4.0);
    private static final VoxelShape OVEN_PILLAR_3 = Block.box((double)4.0, (double)4.0, (double)12.0, (double)6.0, (double)10.0, (double)14.0);
    private static final VoxelShape OVEN_PILLAR_4 = Block.box((double)10.0, (double)4.0, (double)12.0, (double)12.0, (double)10.0, (double)14.0);
    private static final VoxelShape OVEN_SHAFT = Block.box((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)10.0, (double)9.0);
    protected static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)OVEN_SLAB, (VoxelShape[])new VoxelShape[]{OVEN_SLAB_2, OVEN_CONNECTION, OVEN_PILLAR_1, OVEN_PILLAR_2, OVEN_PILLAR_3, OVEN_PILLAR_4, OVEN_SHAFT});
    protected static final Map<Direction, VoxelShape> SHAPES = ShapeHelper.directionShapes(Direction.NORTH, SHAPE_NORTH);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    protected AbstractMillBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        AbstractMillBlockEntity mill = (AbstractMillBlockEntity)level.getBlockEntity(pos);
        IItemHandler inv = ECContainerHelper.getItemHandlerAt((BlockGetter)level, pos, null);
        if (mill != null && hand == InteractionHand.MAIN_HAND) {
            if (!mill.getInventory().getItem(1).isEmpty()) {
                return this.onSlotActivated(inv, player, ItemStack.EMPTY, 1);
            }
            return this.onSlotActivated(inv, player, stack, 0);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(WaterLoggingHelper.isPlacedInWater(context)));
    }

    @Nonnull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Nonnull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING});
    }

    public boolean canSurvive(@Nonnull BlockState state, @Nonnull LevelReader level, BlockPos pos) {
        return ElementContainer.isValidContainer(state, level, pos.below());
    }

    @Nonnull
    public FluidState getFluidState(@Nonnull BlockState state) {
        return WaterLoggingHelper.isWaterlogged(state) ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }
}

