/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.io.firefurnace;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.instrument.io.AbstractIOInstrumentBlockEntity;
import sirttas.elementalcraft.container.IOContainer;
import sirttas.elementalcraft.recipe.instrument.io.FurnaceRecipeWrapper;
import sirttas.elementalcraft.recipe.instrument.io.IOInstrumentRecipeInput;
import sirttas.elementalcraft.recipe.instrument.io.SimpleIOInstrumentRecipeInput;

public abstract class AbstractFireFurnaceBlockEntity<T extends AbstractCookingRecipe>
extends AbstractIOInstrumentBlockEntity<IOInstrumentRecipeInput, FurnaceRecipeWrapper> {
    private float exp = 0.0f;
    private final IOContainer inventory = new IOContainer(this::setChanged);

    protected AbstractFireFurnaceBlockEntity(Supplier<? extends BlockEntityType<?>> blockEntityType, Holder<IConfigurableBlockEntityProperties> properties, BlockPos pos, BlockState state) {
        super(blockEntityType, properties, pos, state);
    }

    @Override
    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.exp = compound.getFloat("experience");
    }

    @Override
    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putFloat("experience", this.exp);
    }

    @Override
    @NotNull
    protected SimpleIOInstrumentRecipeInput createRecipeInput() {
        return this.createSimpleIORecipeInput();
    }

    @Override
    protected FurnaceRecipeWrapper lookupRecipe(@NotNull IOInstrumentRecipeInput recipeInput) {
        return this.getLevel().getRecipeManager().getRecipeFor(this.getProperties().getRecipeType(), (RecipeInput)recipeInput.toSingleRecipeInput(), this.getLevel()).map(h -> new FurnaceRecipeWrapper((AbstractCookingRecipe)h.value())).orElse(null);
    }

    @Override
    protected void renderProgressParticles() {
        RandomSource rand = this.level.random;
        double x = (double)this.worldPosition.getX() + (5.0 + rand.nextDouble() * 6.0) / 16.0;
        double y = (double)this.worldPosition.getY() + 0.375;
        double z = (double)this.worldPosition.getZ() + (5.0 + rand.nextDouble() * 6.0) / 16.0;
        this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
        this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y + 0.5, z, 0.0, 0.0, 0.0);
    }

    @Override
    public void assemble() {
        super.assemble();
        this.addExperience(((FurnaceRecipeWrapper)this.recipe).getExperience());
    }

    public void dropExperience(ServerPlayer player) {
        ExperienceOrb.award((ServerLevel)player.serverLevel(), (Vec3)player.position(), (int)Math.round(this.exp));
        this.exp = 0.0f;
    }

    public void addExperience(float exp) {
        this.exp += exp;
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.inventory;
    }
}

