/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.io;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.instrument.AbstractInstrumentBlockEntity;
import sirttas.elementalcraft.recipe.instrument.io.IOInstrumentRecipe;
import sirttas.elementalcraft.recipe.instrument.io.IOInstrumentRecipeInput;
import sirttas.elementalcraft.recipe.instrument.io.SimpleIOInstrumentRecipeInput;

public abstract class AbstractIOInstrumentBlockEntity<I extends IOInstrumentRecipeInput, R extends IOInstrumentRecipe<I>>
extends AbstractInstrumentBlockEntity<I, R> {
    protected AbstractIOInstrumentBlockEntity(Supplier<? extends BlockEntityType<?>> blockEntityType, Holder<IConfigurableBlockEntityProperties> properties, BlockPos pos, BlockState state) {
        super(blockEntityType, properties, pos, state);
    }

    @NotNull
    protected SimpleIOInstrumentRecipeInput createSimpleIORecipeInput() {
        Container inv = this.getInventory();
        ISingleElementStorage container = this.getContainer();
        return new SimpleIOInstrumentRecipeInput(inv.getItem(0), inv.getItem(1), this.level.getRandom(), container.getElementType(), container.getElementAmount(), this.getRuneHandler().getBonuses());
    }

    @Override
    public void assemble() {
        IOInstrumentRecipeInput input = (IOInstrumentRecipeInput)this.createRecipeInput();
        ItemStack craftingResult = ((IOInstrumentRecipe)this.recipe).assemble(input, (HolderLookup.Provider)this.level.registryAccess());
        int inputSize = ((IOInstrumentRecipe)this.recipe).getInputSize();
        int luck = ((IOInstrumentRecipe)this.recipe).getLuck(input);
        if (luck > 0 && ((IOInstrumentRecipe)this.recipe).getRandomSource(input).nextInt(100) < luck) {
            craftingResult.grow(1);
        }
        int count = craftingResult.getCount();
        Container inv = this.getInventory();
        ItemStack in = inv.getItem(0);
        ItemStack result = inv.getItem(1);
        if (ItemStack.isSameItem((ItemStack)craftingResult, (ItemStack)result) && result.getCount() + count <= result.getMaxStackSize()) {
            in.shrink(inputSize);
            result.grow(count);
        } else if (result.isEmpty()) {
            in.shrink(inputSize);
            inv.setItem(1, craftingResult);
        }
        if (in.isEmpty()) {
            inv.removeItemNoUpdate(0);
        }
    }
}

