/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.inscriber;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sirttas.elementalcraft.block.instrument.InstrumentContainer;
import sirttas.elementalcraft.block.instrument.inscriber.InscriberBlockEntity;
import sirttas.elementalcraft.block.instrument.io.purifier.PurifierBlock;
import sirttas.elementalcraft.renderer.ECRendererHelper;

@OnlyIn(value=Dist.CLIENT)
public class InscriberRenderer
implements BlockEntityRenderer<InscriberBlockEntity> {
    public void render(InscriberBlockEntity te, float partialTicks, PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        float tick = ECRendererHelper.getClientTicks(partialTicks);
        InstrumentContainer inv = (InstrumentContainer)te.getInventory();
        matrixStack.translate(0.0f, 0.25f, 0.0f);
        ECRendererHelper.renderRunes(matrixStack, buffer, te.getRuneHandler(), tick, light, overlay);
        matrixStack.translate(0.5f, 0.15f, 0.5f);
        matrixStack.mulPose(ECRendererHelper.getRotation((Direction)te.getBlockState().getValue((Property)PurifierBlock.FACING)));
        this.renderRuneSlate(matrixStack, buffer, light, overlay, inv.getItem(0));
        this.renderItems(matrixStack, buffer, light, overlay, tick, inv);
    }

    private void renderRuneSlate(PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay, ItemStack stack) {
        if (!stack.isEmpty()) {
            matrixStack.pushPose();
            matrixStack.translate(0.0f, 0.0f, 0.0625f);
            matrixStack.mulPose(Axis.XP.rotationDegrees(22.5f));
            ECRendererHelper.renderItem(stack, matrixStack, buffer, light, overlay);
            matrixStack.popPose();
        }
    }

    private void renderItems(PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay, float tick, InstrumentContainer inv) {
        matrixStack.translate(-0.4f, -0.2f, -0.2f);
        for (int i = 1; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            matrixStack.pushPose();
            matrixStack.mulPose(Axis.YP.rotationDegrees(tick));
            matrixStack.scale(0.5f, 0.5f, 0.5f);
            ECRendererHelper.renderItem(stack, matrixStack, buffer, light, overlay);
            matrixStack.popPose();
            matrixStack.translate(0.4f, 0.0f, 0.0f);
        }
    }
}

