/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.inscriber;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.WaterLoggingHelper;
import sirttas.elementalcraft.block.container.ElementContainer;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.instrument.IInstrumentBlock;
import sirttas.elementalcraft.block.instrument.inscriber.InscriberBlockEntity;
import sirttas.elementalcraft.container.ECContainerHelper;
import sirttas.elementalcraft.tag.ECTags;

public class InscriberBlock
extends AbstractECContainerBlock
implements IInstrumentBlock {
    public static final String NAME = "inscriber";
    public static final MapCodec<InscriberBlock> CODEC = InscriberBlock.simpleCodec(InscriberBlock::new);
    private static final VoxelShape BASE_1 = Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape CONNECTION = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0);
    private static final VoxelShape BASE_PIPE_1 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)3.0, (double)3.0);
    private static final VoxelShape BACK_BASE_PIPE_1 = Block.box((double)1.0, (double)4.0, (double)1.0, (double)3.0, (double)5.0, (double)3.0);
    private static final VoxelShape BASE_PIPE_2 = Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)3.0);
    private static final VoxelShape BACK_BASE_PIPE_2 = Block.box((double)13.0, (double)4.0, (double)1.0, (double)15.0, (double)5.0, (double)3.0);
    private static final VoxelShape BASE_PIPE_3 = Block.box((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)15.0);
    private static final VoxelShape BACK_BASE_PIPE_3 = Block.box((double)1.0, (double)4.0, (double)13.0, (double)3.0, (double)5.0, (double)15.0);
    private static final VoxelShape BASE_PIPE_4 = Block.box((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)3.0, (double)15.0);
    private static final VoxelShape BACK_BASE_PIPE_4 = Block.box((double)13.0, (double)4.0, (double)13.0, (double)15.0, (double)5.0, (double)15.0);
    private static final VoxelShape BASE_SHAPE = Shapes.or((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{CONNECTION, BASE_PIPE_1, BASE_PIPE_2, BASE_PIPE_3, BASE_PIPE_4});
    private static final VoxelShape BACK_BASE_NORTH = Block.box((double)0.0, (double)3.0, (double)12.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape BACK_PIPE_1_NORTH = Block.box((double)4.0, (double)2.0, (double)13.0, (double)6.0, (double)15.0, (double)15.0);
    private static final VoxelShape BACK_PIPE_2_NORTH = Block.box((double)10.0, (double)2.0, (double)13.0, (double)12.0, (double)15.0, (double)15.0);
    private static final VoxelShape BACK_NORTH = Shapes.or((VoxelShape)BACK_BASE_NORTH, (VoxelShape[])new VoxelShape[]{BACK_BASE_PIPE_3, BACK_BASE_PIPE_4, BACK_PIPE_1_NORTH, BACK_PIPE_2_NORTH});
    private static final VoxelShape PLATE_1_NORTH = Block.box((double)1.0, (double)2.0, (double)8.0, (double)15.0, (double)5.0, (double)11.0);
    private static final VoxelShape PLATE_2_NORTH = Block.box((double)1.0, (double)5.0, (double)9.0, (double)15.0, (double)8.0, (double)12.0);
    private static final VoxelShape PLATE_3_NORTH = Block.box((double)1.0, (double)8.0, (double)10.0, (double)15.0, (double)11.0, (double)13.0);
    private static final VoxelShape PLATE_4_NORTH = Block.box((double)1.0, (double)11.0, (double)11.0, (double)15.0, (double)14.0, (double)14.0);
    private static final VoxelShape PLATE_5_NORTH = Block.box((double)1.0, (double)14.0, (double)12.0, (double)15.0, (double)17.0, (double)15.0);
    private static final VoxelShape PLATE_NORTH = Shapes.or((VoxelShape)PLATE_1_NORTH, (VoxelShape[])new VoxelShape[]{PLATE_2_NORTH, PLATE_3_NORTH, PLATE_4_NORTH, PLATE_5_NORTH});
    private static final VoxelShape BACK_BASE_SOUTH = Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0);
    private static final VoxelShape BACK_PIPE_1_SOUTH = Block.box((double)4.0, (double)2.0, (double)1.0, (double)6.0, (double)15.0, (double)3.0);
    private static final VoxelShape BACK_PIPE_2_SOUTH = Block.box((double)10.0, (double)2.0, (double)1.0, (double)12.0, (double)15.0, (double)3.0);
    private static final VoxelShape BACK_SOUTH = Shapes.or((VoxelShape)BACK_BASE_SOUTH, (VoxelShape[])new VoxelShape[]{BACK_BASE_PIPE_1, BACK_BASE_PIPE_2, BACK_PIPE_1_SOUTH, BACK_PIPE_2_SOUTH});
    private static final VoxelShape PLATE_1_SOUTH = Block.box((double)1.0, (double)2.0, (double)5.0, (double)15.0, (double)5.0, (double)8.0);
    private static final VoxelShape PLATE_2_SOUTH = Block.box((double)1.0, (double)5.0, (double)4.0, (double)15.0, (double)8.0, (double)7.0);
    private static final VoxelShape PLATE_3_SOUTH = Block.box((double)1.0, (double)8.0, (double)3.0, (double)15.0, (double)11.0, (double)6.0);
    private static final VoxelShape PLATE_4_SOUTH = Block.box((double)1.0, (double)11.0, (double)2.0, (double)15.0, (double)14.0, (double)5.0);
    private static final VoxelShape PLATE_5_SOUTH = Block.box((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)17.0, (double)4.0);
    private static final VoxelShape PLATE_SOUTH = Shapes.or((VoxelShape)PLATE_1_SOUTH, (VoxelShape[])new VoxelShape[]{PLATE_2_SOUTH, PLATE_3_SOUTH, PLATE_4_SOUTH, PLATE_5_SOUTH});
    private static final VoxelShape BACK_BASE_WEST = Block.box((double)12.0, (double)3.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape BACK_PIPE_1_WEST = Block.box((double)13.0, (double)2.0, (double)4.0, (double)15.0, (double)15.0, (double)6.0);
    private static final VoxelShape BACK_PIPE_2_WEST = Block.box((double)13.0, (double)2.0, (double)10.0, (double)15.0, (double)15.0, (double)12.0);
    private static final VoxelShape BACK_WEST = Shapes.or((VoxelShape)BACK_BASE_WEST, (VoxelShape[])new VoxelShape[]{BACK_BASE_PIPE_2, BACK_BASE_PIPE_4, BACK_PIPE_1_WEST, BACK_PIPE_2_WEST});
    private static final VoxelShape PLATE_1_WEST = Block.box((double)8.0, (double)2.0, (double)1.0, (double)11.0, (double)5.0, (double)15.0);
    private static final VoxelShape PLATE_2_WEST = Block.box((double)9.0, (double)5.0, (double)1.0, (double)12.0, (double)8.0, (double)15.0);
    private static final VoxelShape PLATE_3_WEST = Block.box((double)10.0, (double)8.0, (double)1.0, (double)13.0, (double)11.0, (double)15.0);
    private static final VoxelShape PLATE_4_WEST = Block.box((double)11.0, (double)11.0, (double)1.0, (double)14.0, (double)14.0, (double)15.0);
    private static final VoxelShape PLATE_5_WEST = Block.box((double)12.0, (double)14.0, (double)1.0, (double)15.0, (double)17.0, (double)15.0);
    private static final VoxelShape PLATE_WEST = Shapes.or((VoxelShape)PLATE_1_WEST, (VoxelShape[])new VoxelShape[]{PLATE_2_WEST, PLATE_3_WEST, PLATE_4_WEST, PLATE_5_WEST});
    private static final VoxelShape BACK_BASE_EAST = Block.box((double)0.0, (double)3.0, (double)0.0, (double)4.0, (double)4.0, (double)16.0);
    private static final VoxelShape BACK_PIPE_1_EAST = Block.box((double)1.0, (double)2.0, (double)4.0, (double)3.0, (double)15.0, (double)6.0);
    private static final VoxelShape BACK_PIPE_2_EAST = Block.box((double)1.0, (double)2.0, (double)10.0, (double)3.0, (double)15.0, (double)12.0);
    private static final VoxelShape BACK_EAST = Shapes.or((VoxelShape)BACK_BASE_EAST, (VoxelShape[])new VoxelShape[]{BACK_BASE_PIPE_1, BACK_BASE_PIPE_3, BACK_PIPE_1_EAST, BACK_PIPE_2_EAST});
    private static final VoxelShape PLATE_1_EAST = Block.box((double)5.0, (double)2.0, (double)1.0, (double)8.0, (double)5.0, (double)15.0);
    private static final VoxelShape PLATE_2_EAST = Block.box((double)4.0, (double)5.0, (double)1.0, (double)7.0, (double)8.0, (double)15.0);
    private static final VoxelShape PLATE_3_EAST = Block.box((double)3.0, (double)8.0, (double)1.0, (double)6.0, (double)11.0, (double)15.0);
    private static final VoxelShape PLATE_4_EAST = Block.box((double)2.0, (double)11.0, (double)1.0, (double)5.0, (double)14.0, (double)15.0);
    private static final VoxelShape PLATE_5_EAST = Block.box((double)1.0, (double)14.0, (double)1.0, (double)4.0, (double)17.0, (double)15.0);
    private static final VoxelShape PLATE_EAST = Shapes.or((VoxelShape)PLATE_1_EAST, (VoxelShape[])new VoxelShape[]{PLATE_2_EAST, PLATE_3_EAST, PLATE_4_EAST, PLATE_5_EAST});
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{BACK_NORTH, PLATE_NORTH});
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{BACK_SOUTH, PLATE_SOUTH});
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{BACK_WEST, PLATE_WEST});
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{BACK_EAST, PLATE_EAST});
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public InscriberBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<InscriberBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new InscriberBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return this.createInstrumentTicker(level, type, ECBlockEntityTypes.INSCRIBER);
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, Level level, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        InscriberBlockEntity inscriber = (InscriberBlockEntity)level.getBlockEntity(pos);
        ItemStack heldItem = player.getItemInHand(hand);
        IItemHandler inv = ECContainerHelper.getItemHandlerAt((BlockGetter)level, pos, null);
        if (inscriber != null && hand == InteractionHand.MAIN_HAND) {
            if (heldItem.is(ECTags.Items.CHISELS) && !inscriber.isLocked()) {
                return this.makeProgress(player, hand, inscriber, heldItem);
            }
            if ((inscriber.isLocked() || heldItem.isEmpty() || player.isShiftKeyDown()) && !inscriber.getInventory().isEmpty()) {
                for (int i = 0; i < inv.getSlots(); ++i) {
                    this.onSlotActivated(inv, player, ItemStack.EMPTY, i);
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (heldItem.is(ECTags.Items.CHISELS)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (!inv.getStackInSlot(i).isEmpty() || this.onSlotActivated(inv, player, heldItem, i) != ItemInteractionResult.SUCCESS) continue;
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private ItemInteractionResult makeProgress(Player player, InteractionHand hand, InscriberBlockEntity inscriber, ItemStack heldItem) {
        if (inscriber.useChisel()) {
            if (heldItem.isDamageableItem() && !player.getAbilities().instabuild) {
                heldItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> BASE_SHAPE;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(WaterLoggingHelper.isPlacedInWater(context)));
    }

    @Nonnull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Nonnull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING});
    }

    public boolean canSurvive(@NotNull BlockState state, @Nonnull LevelReader level, BlockPos pos) {
        return ElementContainer.isValidContainer(state, level, pos.below());
    }

    @Nonnull
    public FluidState getFluidState(@Nonnull BlockState state) {
        return WaterLoggingHelper.isWaterlogged(state) ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        WaterLoggingHelper.scheduleWaterTick(state, level, pos);
        return !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, pos, facingPos);
    }
}

