/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.infuser;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.WaterLoggingHelper;
import sirttas.elementalcraft.block.container.ElementContainer;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.instrument.IInstrumentBlock;
import sirttas.elementalcraft.block.instrument.infuser.InfuserBlockEntity;

public class InfuserBlock
extends AbstractECContainerBlock
implements IInstrumentBlock {
    public static final String NAME = "infuser";
    public static final MapCodec<InfuserBlock> CODEC = InfuserBlock.simpleCodec(InfuserBlock::new);
    private static final VoxelShape BASE_1 = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0);
    private static final VoxelShape BASE_2 = Block.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    private static final VoxelShape PIPE_1 = Block.box((double)3.0, (double)0.0, (double)3.0, (double)5.0, (double)4.0, (double)5.0);
    private static final VoxelShape PIPE_2 = Block.box((double)11.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)5.0);
    private static final VoxelShape PIPE_3 = Block.box((double)3.0, (double)0.0, (double)11.0, (double)5.0, (double)4.0, (double)13.0);
    private static final VoxelShape PIPE_4 = Block.box((double)11.0, (double)0.0, (double)11.0, (double)13.0, (double)4.0, (double)13.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{BASE_2, PIPE_1, PIPE_2, PIPE_3, PIPE_4});

    public InfuserBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<InfuserBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new InfuserBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return this.createInstrumentTicker(level, type, ECBlockEntityTypes.INFUSER);
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        return this.onSingleSlotActivated(stack, level, pos, player, hand);
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public boolean canSurvive(@NotNull BlockState state, @Nonnull LevelReader level, BlockPos pos) {
        return ElementContainer.isValidContainer(state, level, pos.below());
    }

    @Nullable
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(WaterLoggingHelper.isPlacedInWater(context)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    @Nonnull
    public FluidState getFluidState(@Nonnull BlockState state) {
        return WaterLoggingHelper.isWaterlogged(state) ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        WaterLoggingHelper.scheduleWaterTick(state, level, pos);
        return !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, pos, facingPos);
    }
}

