/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.enchantment.liquefier;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.instrument.AbstractInstrumentBlockEntity;
import sirttas.elementalcraft.block.instrument.InstrumentContainer;
import sirttas.elementalcraft.block.instrument.enchantment.liquefier.EnchantmentLiquefierContainer;
import sirttas.elementalcraft.block.instrument.enchantment.liquefier.EnchantmentLiquefierHelper;
import sirttas.elementalcraft.recipe.instrument.enchantment.liquefaction.EnchantmentLiquefactionRecipe;
import sirttas.elementalcraft.recipe.instrument.io.SimpleIOInstrumentRecipeInput;

public class EnchantmentLiquefierBlockEntity
extends AbstractInstrumentBlockEntity<SimpleIOInstrumentRecipeInput, EnchantmentLiquefactionRecipe> {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("enchantment_liquefier");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);
    private final InstrumentContainer inventory = new EnchantmentLiquefierContainer(this);

    public EnchantmentLiquefierBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.ENCHANTMENT_LIQUEFIER, PROPERTIES, pos, state);
        this.particleOffset = new Vec3(0.0, 0.4, 0.0);
    }

    @Override
    @NotNull
    public Container getInventory() {
        return this.inventory;
    }

    @Override
    @NotNull
    protected SimpleIOInstrumentRecipeInput createRecipeInput() {
        Container inv = this.getInventory();
        ISingleElementStorage container = this.getContainer();
        return new SimpleIOInstrumentRecipeInput(inv.getItem(0), inv.getItem(1), 1, this.level.getRandom(), container.getElementType(), container.getElementAmount(), this.getRuneHandler().getBonuses());
    }

    @Override
    protected EnchantmentLiquefactionRecipe lookupRecipe(@NotNull SimpleIOInstrumentRecipeInput recipeInput) {
        if (this.level == null) {
            return null;
        }
        ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)this.inventory.getItem(0));
        for (Holder enchantment : enchantments.keySet()) {
            EnchantmentLiquefactionRecipe recipe = new EnchantmentLiquefactionRecipe((Holder<Enchantment>)enchantment);
            if (!recipe.matches(this.createRecipeInput(), this.level)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    protected void updateLock() {
        this.locked = !EnchantmentLiquefierHelper.isValidInput(this.inventory.getItem(0));
    }

    @Override
    protected void renderProgressParticles() {
        RandomSource rand = this.level.random;
        if (rand.nextInt(4) != 0) {
            return;
        }
        double x = (double)this.worldPosition.getX() + (5.0 + rand.nextDouble() * 6.0) / 16.0;
        double y = (double)this.worldPosition.getY() + 1.25;
        double z = (double)this.worldPosition.getZ() + (5.0 + rand.nextDouble() * 6.0) / 16.0;
        this.level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, x, y, z, 0.0, 0.33, 0.0);
    }
}

